/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.postprocessor;

import javax.persistence.metamodel.SingularAttribute;
import org.apache.deltaspike.data.impl.builder.OrderDirection;
import org.apache.deltaspike.data.impl.handler.QueryStringPostProcessor;

public class OrderByQueryStringPostProcessor
implements QueryStringPostProcessor {
    private static final String ORDER_BY = " order by ";
    private final String attribute;
    private OrderDirection direction;

    public OrderByQueryStringPostProcessor(SingularAttribute<?, ?> attribute, OrderDirection direction) {
        this.attribute = attribute.getName();
        this.direction = direction;
    }

    public OrderByQueryStringPostProcessor(String attribute, OrderDirection direction) {
        this.attribute = attribute;
        this.direction = direction;
    }

    @Override
    public String postProcess(String queryString) {
        StringBuilder builder = new StringBuilder(queryString);
        if (queryString.contains(ORDER_BY)) {
            builder.append(",");
        } else {
            builder.append(ORDER_BY);
        }
        return builder.append("e").append(".").append(this.attribute).append(" ").append((Object)this.direction).toString();
    }

    public boolean matches(SingularAttribute<?, ?> attribute) {
        return this.matches(attribute.getName());
    }

    public boolean matches(String attribute) {
        return this.attribute.equals(attribute);
    }

    public void changeDirection() {
        this.direction = this.direction.change();
    }
}

