/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder.postprocessor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Query;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.handler.JpaQueryPostProcessor;
import org.apache.deltaspike.data.impl.param.Parameters;
import org.apache.deltaspike.data.impl.util.QueryUtils;
import org.apache.deltaspike.data.impl.util.jpa.QueryStringExtractorFactory;

public class CountQueryPostProcessor
implements JpaQueryPostProcessor {
    private static final Logger log = Logger.getLogger(CountQueryPostProcessor.class.getName());
    private final QueryStringExtractorFactory factory = new QueryStringExtractorFactory();

    @Override
    public Query postProcess(CdiQueryInvocationContext context, Query query) {
        String queryString = this.getQueryString(context, query);
        QueryExtraction extract = new QueryExtraction(queryString);
        String count = extract.rewriteToCount();
        log.log(Level.FINER, "Rewrote query {0} to {1}", new Object[]{queryString, count});
        Query result = context.getEntityManager().createQuery(count);
        Parameters params = context.getParams();
        params.applyTo(result);
        return result;
    }

    private String getQueryString(CdiQueryInvocationContext context, Query query) {
        if (QueryUtils.isNotEmpty(context.getQueryString())) {
            return context.getQueryString();
        }
        return this.factory.extract(query);
    }

    private static class QueryExtraction {
        private String select;
        private String from;
        private String where;
        private String entityName;
        private final String query;

        public QueryExtraction(String query) {
            this.query = query;
        }

        public String rewriteToCount() {
            this.splitQuery();
            this.extractEntityName();
            return this.rewrite();
        }

        private String rewrite() {
            return "select count(" + QueryUtils.nullSafeValue(this.select, this.entityName) + ") " + this.from + QueryUtils.nullSafeValue(this.where);
        }

        private void extractEntityName() {
            String[] split = this.from.split(" ");
            this.entityName = split.length > 1 ? split[split.length - 1] : "*";
        }

        private void splitQuery() {
            String lower = this.query.toLowerCase();
            int selectIndex = lower.indexOf("select");
            int fromIndex = lower.indexOf("from");
            int whereIndex = lower.indexOf("where");
            if (selectIndex >= 0) {
                this.select = this.query.substring("select".length(), fromIndex);
            }
            if (whereIndex >= 0) {
                this.from = this.query.substring(fromIndex, whereIndex);
                this.where = this.query.substring(whereIndex);
            } else {
                this.from = this.query.substring(fromIndex);
            }
        }
    }
}

