/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import org.apache.deltaspike.data.api.QueryResult;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.param.Parameters;

public abstract class QueryBuilder {
    public static final String QUERY_SELECT = "select e from {0} e";
    public static final String QUERY_COUNT = "select count(e) from {0} e";
    public static final String ENTITY_NAME = "e";

    public static String selectQuery(String entityName) {
        return MessageFormat.format(QUERY_SELECT, entityName);
    }

    public static String countQuery(String entityName) {
        return MessageFormat.format(QUERY_COUNT, entityName);
    }

    public Object executeQuery(CdiQueryInvocationContext context) {
        Object result = this.execute(context);
        if (!this.isUnmappableResult(result) && context.hasQueryInOutMapper()) {
            QueryInOutMapper<?> mapper = context.getQueryInOutMapper();
            if (result instanceof List) {
                return mapper.mapResultList((List)result);
            }
            return mapper.mapResult(result);
        }
        return result;
    }

    protected abstract Object execute(CdiQueryInvocationContext var1);

    protected boolean returnsList(Method method) {
        return method.getReturnType().isAssignableFrom(List.class);
    }

    protected LockModeType extractLockMode(Method method) {
        Class<org.apache.deltaspike.data.api.Query> query = org.apache.deltaspike.data.api.Query.class;
        if (method.isAnnotationPresent(query) && method.getAnnotation(query).lock() != LockModeType.NONE) {
            return method.getAnnotation(query).lock();
        }
        return null;
    }

    protected boolean hasLockMode(Method method) {
        return this.extractLockMode(method) != null;
    }

    protected QueryHint[] extractQueryHints(Method method) {
        Class<org.apache.deltaspike.data.api.Query> query = org.apache.deltaspike.data.api.Query.class;
        if (method.isAnnotationPresent(query) && method.getAnnotation(query).hints().length > 0) {
            return method.getAnnotation(query).hints();
        }
        return null;
    }

    protected boolean hasQueryHints(Method method) {
        return this.extractQueryHints(method) != null;
    }

    protected Query applyRestrictions(CdiQueryInvocationContext context, Query query) {
        Parameters params = context.getParams();
        Method method = context.getMethod();
        if (params.hasSizeRestriction()) {
            query.setMaxResults(params.getSizeRestriciton());
        }
        if (params.hasFirstResult()) {
            query.setFirstResult(params.getFirstResult());
        }
        if (this.hasLockMode(method)) {
            query.setLockMode(this.extractLockMode(method));
        }
        if (this.hasQueryHints(method)) {
            QueryHint[] hints;
            for (QueryHint hint : hints = this.extractQueryHints(method)) {
                query.setHint(hint.name(), (Object)hint.value());
            }
        }
        query = context.applyJpaQueryPostProcessors(query);
        return query;
    }

    private boolean isUnmappableResult(Object result) {
        return result instanceof QueryResult || result instanceof Query;
    }
}

