/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.builder;

import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.deltaspike.data.impl.builder.QueryBuilder;
import org.apache.deltaspike.data.impl.handler.CdiQueryInvocationContext;
import org.apache.deltaspike.data.impl.meta.MethodType;
import org.apache.deltaspike.data.impl.meta.QueryInvocation;
import org.apache.deltaspike.data.impl.param.Parameters;
import org.apache.deltaspike.data.impl.util.QueryUtils;
import org.apache.deltaspike.data.impl.util.jpa.QueryStringExtractorFactory;

@QueryInvocation(value=MethodType.ANNOTATED)
public class AnnotatedQueryBuilder
extends QueryBuilder {
    private final QueryStringExtractorFactory factory = new QueryStringExtractorFactory();

    @Override
    public Object execute(CdiQueryInvocationContext context) {
        Method method = context.getMethod();
        org.apache.deltaspike.data.api.Query query = method.getAnnotation(org.apache.deltaspike.data.api.Query.class);
        Query jpaQuery = this.createJpaQuery(query, context);
        return context.executeQuery(jpaQuery);
    }

    private Query createJpaQuery(org.apache.deltaspike.data.api.Query query, CdiQueryInvocationContext context) {
        EntityManager entityManager = context.getEntityManager();
        Parameters params = context.getParams();
        Query result = null;
        if (QueryUtils.isNotEmpty(query.named())) {
            if (!context.hasQueryStringPostProcessors()) {
                result = params.applyTo(entityManager.createNamedQuery(query.named()));
            } else {
                Query namedQuery = entityManager.createNamedQuery(query.named());
                String named = this.factory.extract(namedQuery);
                String jpqlQuery = context.applyQueryStringPostProcessors(named);
                result = params.applyTo(entityManager.createQuery(jpqlQuery));
            }
        } else if (query.isNative()) {
            String jpqlQuery = context.applyQueryStringPostProcessors(query.value());
            result = params.applyTo(entityManager.createNativeQuery(jpqlQuery));
        } else {
            String jpqlQuery = context.applyQueryStringPostProcessors(query.value());
            context.setQueryString(jpqlQuery);
            result = params.applyTo(entityManager.createQuery(jpqlQuery));
        }
        return this.applyRestrictions(context, result);
    }
}

