/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.NonNativeValueLayouts;
import org.apache.datasketches.memory.internal.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.WritableBufferImpl;

final class NonNativeWritableBufferImpl
extends WritableBufferImpl {
    NonNativeWritableBufferImpl(MemorySegment seg, int typeId, MemoryRequestServer memReqSvr, Arena arena) {
        super(seg, typeId, memReqSvr, arena);
    }

    @Override
    public char getChar() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return this.seg.get(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getCharArr(this.seg, pos, dstArray, dstOffsetChars, lengthChars);
        this.setPosition(pos + (long)lengthChars << 1);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return this.seg.get(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public double getDouble(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getDoubleArr(this.seg, pos, dstArray, dstOffsetDoubles, lengthDoubles);
        this.setPosition(pos + (long)lengthDoubles << 3);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return this.seg.get(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public float getFloat(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getFloatArr(this.seg, pos, dstArray, dstOffsetFloats, lengthFloats);
        this.setPosition(pos + (long)lengthFloats << 2);
    }

    @Override
    public int getInt() {
        long pos = this.getPosition();
        this.setPosition(pos + 4L);
        return this.seg.get(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getIntArr(this.seg, pos, dstArray, dstOffsetInts, lengthInts);
        this.setPosition(pos + (long)lengthInts << 2);
    }

    @Override
    public long getLong() {
        long pos = this.getPosition();
        this.setPosition(pos + 8L);
        return this.seg.get(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getLongArr(this.seg, pos, dstArray, dstOffsetLongs, lengthLongs);
        this.setPosition(pos + (long)lengthLongs << 3);
    }

    @Override
    public short getShort() {
        long pos = this.getPosition();
        this.setPosition(pos + 2L);
        return this.seg.get(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, pos);
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.seg.get(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes);
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.getShortArr(this.seg, pos, dstArray, dstOffsetShorts, lengthShorts);
        this.setPosition(pos + (long)lengthShorts << 1);
    }

    @Override
    public void putChar(char value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 2L);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.seg.set(NonNativeValueLayouts.JAVA_CHAR_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putCharArr(this.seg, pos, srcArray, srcOffsetChars, lengthChars);
        this.setPosition(pos + (long)lengthChars << 1);
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 8L);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.seg.set(NonNativeValueLayouts.JAVA_DOUBLE_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putDoubleArr(this.seg, pos, srcArray, srcOffsetDoubles, lengthDoubles);
        this.setPosition(pos + (long)lengthDoubles << 3);
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 4L);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.seg.set(NonNativeValueLayouts.JAVA_FLOAT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putFloatArr(this.seg, pos, srcArray, srcOffsetFloats, lengthFloats);
        this.setPosition(pos + (long)lengthFloats << 2);
    }

    @Override
    public void putInt(int value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 4L);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.seg.set(NonNativeValueLayouts.JAVA_INT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putIntArr(this.seg, pos, srcArray, srcOffsetInts, lengthInts);
        this.setPosition(pos + (long)lengthInts << 2);
    }

    @Override
    public void putLong(long value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 8L);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.seg.set(NonNativeValueLayouts.JAVA_LONG_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putLongArr(this.seg, pos, srcArray, srcOffsetLongs, lengthLongs);
        this.setPosition(pos + (long)lengthLongs << 3);
    }

    @Override
    public void putShort(short value) {
        long pos = this.getPosition();
        this.seg.set(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, pos, value);
        this.setPosition(pos + 2L);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.seg.set(NonNativeValueLayouts.JAVA_SHORT_UNALIGNED_NON_NATIVE, offsetBytes, value);
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        NonNativeWritableMemoryImpl.putShortArr(this.seg, pos, srcArray, srcOffsetShorts, lengthShorts);
        this.setPosition(pos + (long)lengthShorts << 1);
    }
}

