/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;

final class ForwardCompatibility {
    ForwardCompatibility() {
    }

    static final CompactSketch heapify1to3(Memory srcMem, long seed) {
        short seedHash = Util.computeSeedHash(seed);
        return ForwardCompatibility.heapify1to3(srcMem, seedHash);
    }

    static final CompactSketch heapify1to3(Memory srcMem, short seedHash) {
        boolean empty;
        int memCap = (int)srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        if (preLongs != 3) {
            throw new SketchesArgumentException("PreLongs must be 3 for SerVer 1: " + preLongs);
        }
        int familyId = PreambleUtil.extractFamilyID(srcMem);
        if (familyId < 1 || familyId > 3) {
            throw new SketchesArgumentException("Family (Sketch Type) must be 1 to 3: " + familyId);
        }
        int curCount = PreambleUtil.extractCurCount(srcMem);
        long thetaLong = PreambleUtil.extractThetaLong(srcMem);
        boolean bl = empty = curCount == 0 && thetaLong == Long.MAX_VALUE;
        if (empty || memCap <= 24) {
            return EmptyCompactSketch.getInstance();
        }
        int reqCap = curCount + preLongs << 3;
        ForwardCompatibility.validateInputSize(reqCap, memCap);
        if (thetaLong == Long.MAX_VALUE && curCount == 1) {
            long hash = srcMem.getLong((long)(preLongs << 3));
            return new SingleItemSketch(hash, seedHash);
        }
        long[] compactOrderedCache = new long[curCount];
        srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
        return new HeapCompactSketch(compactOrderedCache, false, seedHash, curCount, thetaLong, true);
    }

    static final CompactSketch heapify2to3(Memory srcMem, long seed) {
        short seedHash = PreambleUtil.checkMemorySeedHash(srcMem, seed);
        int memCap = (int)srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int familyId = PreambleUtil.extractFamilyID(srcMem);
        if (familyId < 1 || familyId > 4) {
            throw new SketchesArgumentException("Family (Sketch Type) must be 1 to 4: " + familyId);
        }
        int reqBytesIn = 8;
        int curCount = 0;
        long thetaLong = Long.MAX_VALUE;
        if (preLongs == 1) {
            reqBytesIn = 8;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            return EmptyCompactSketch.getInstance();
        }
        if (preLongs == 2) {
            reqBytesIn = preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            curCount = PreambleUtil.extractCurCount(srcMem);
            if (curCount == 0) {
                return EmptyCompactSketch.getInstance();
            }
            if (curCount == 1) {
                reqBytesIn = preLongs + 1 << 3;
                ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
                long hash = srcMem.getLong((long)(preLongs << 3));
                return new SingleItemSketch(hash, seed);
            }
            reqBytesIn = curCount + preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            long[] compactOrderedCache = new long[curCount];
            srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
            return new HeapCompactSketch(compactOrderedCache, false, seedHash, curCount, thetaLong, true);
        }
        if (preLongs == 3) {
            reqBytesIn = preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            curCount = PreambleUtil.extractCurCount(srcMem);
            thetaLong = PreambleUtil.extractThetaLong(srcMem);
            if (curCount == 0 && thetaLong == Long.MAX_VALUE) {
                return EmptyCompactSketch.getInstance();
            }
            if (curCount == 1 && thetaLong == Long.MAX_VALUE) {
                reqBytesIn = preLongs + 1 << 3;
                ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
                long hash = srcMem.getLong((long)(preLongs << 3));
                return new SingleItemSketch(hash, seed);
            }
            reqBytesIn = curCount + preLongs << 3;
            ForwardCompatibility.validateInputSize(reqBytesIn, memCap);
            long[] compactOrderedCache = new long[curCount];
            srcMem.getLongArray((long)(preLongs << 3), compactOrderedCache, 0, curCount);
            return new HeapCompactSketch(compactOrderedCache, false, seedHash, curCount, thetaLong, true);
        }
        throw new SketchesArgumentException("PreLongs must be 1,2, or 3: " + preLongs);
    }

    private static final void validateInputSize(int reqBytesIn, int memCap) {
        if (reqBytesIn > memCap) {
            throw new SketchesArgumentException("Input Memory or byte[] size is too small: Required Bytes: " + reqBytesIn + ", bytesIn: " + memCap);
        }
    }
}

