/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesAuxiliary;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;

final class Util {
    static final String LS = System.getProperty("line.separator");
    static final char TAB = '\t';

    private Util() {
    }

    public static double computeKSDelta(DoublesSketch sketch1, DoublesSketch sketch2) {
        DoublesAuxiliary p = new DoublesAuxiliary(sketch1);
        DoublesAuxiliary q = new DoublesAuxiliary(sketch2);
        double[] pSamplesArr = p.auxSamplesArr_;
        double[] qSamplesArr = q.auxSamplesArr_;
        long[] pCumWtsArr = p.auxCumWtsArr_;
        long[] qCumWtsArr = q.auxCumWtsArr_;
        int pSamplesArrLen = pSamplesArr.length;
        int qSamplesArrLen = qSamplesArr.length;
        double n1 = sketch1.getN();
        double n2 = sketch2.getN();
        double deltaArea = 0.0;
        int i = Util.getNextIndex(pSamplesArr, -1);
        int j = Util.getNextIndex(qSamplesArr, -1);
        while (i < pSamplesArrLen && j < qSamplesArrLen) {
            double pSample = pSamplesArr[i];
            double qSample = qSamplesArr[j];
            long pWt = pCumWtsArr[i];
            long qWt = qCumWtsArr[j];
            double pNormWt = (double)pWt / n1;
            double qNormWt = (double)qWt / n2;
            double pMinusQ = Math.abs(pNormWt - qNormWt);
            double curD = deltaArea;
            deltaArea = Math.max(curD, pMinusQ);
            if (pSample == qSample) {
                i = Util.getNextIndex(pSamplesArr, i);
                j = Util.getNextIndex(qSamplesArr, j);
                continue;
            }
            if (pSample < qSample) {
                i = Util.getNextIndex(pSamplesArr, i);
                continue;
            }
            j = Util.getNextIndex(qSamplesArr, j);
        }
        deltaArea = Math.max(deltaArea, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
        return deltaArea;
    }

    public static double computeKSThreshold(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double r1 = sketch1.getRetainedItems();
        double r2 = sketch2.getRetainedItems();
        double alpha = tgtPvalue;
        double alphaFactor = Math.sqrt(-0.5 * Math.log(0.5 * alpha));
        double deltaAreaThreshold = alphaFactor * Math.sqrt((r1 + r2) / (r1 * r2));
        double eps1 = Util.getNormalizedRankError(sketch1.getK(), false);
        double eps2 = Util.getNormalizedRankError(sketch2.getK(), false);
        double adjDeltaAreaThreshold = deltaAreaThreshold + eps1 + eps2;
        return adjDeltaAreaThreshold;
    }

    public static boolean kolmogorovSmirnovTest(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double thresh;
        double delta = Util.computeKSDelta(sketch1, sketch2);
        return delta > (thresh = Util.computeKSThreshold(sketch1, sketch2, tgtPvalue));
    }

    private static final int getNextIndex(double[] samplesArr, int stIdx) {
        int idx = stIdx + 1;
        int samplesArrLen = samplesArr.length;
        if (idx >= samplesArrLen) {
            return samplesArrLen;
        }
        double val = samplesArr[idx];
        int nxtIdx = idx + 1;
        while (nxtIdx < samplesArrLen && samplesArr[nxtIdx] == val) {
            idx = nxtIdx++;
        }
        return idx;
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return pmf ? 1.854 / Math.pow(k, 0.9657) : 1.576 / Math.pow(k, 0.9726);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        double eps = Math.max(epsilon, 6.395E-5);
        double kdbl = pmf ? Math.exp(Math.log(1.854 / eps) / 0.9657) : Math.exp(Math.log(1.576 / eps) / 0.9726);
        double krnd = Math.round(kdbl);
        double del = Math.abs(krnd - kdbl);
        int k = (int)(del < 1.0E-6 ? krnd : Math.ceil(kdbl));
        return Math.max(2, Math.min(32768, k));
    }

    static void checkK(int k) {
        if (k < 2 || k > 32768 || !org.apache.datasketches.Util.isPowerOf2(k)) {
            throw new SketchesArgumentException("K must be >= 2 and <= 32768 and a power of 2: " + k);
        }
    }

    static void checkFamilyID(int familyID) {
        Family family = Family.idToFamily(familyID);
        if (!family.equals((Object)Family.QUANTILES)) {
            throw new SketchesArgumentException("Possible corruption: Invalid Family: " + family.toString());
        }
    }

    static boolean checkPreLongsFlagsCap(int preambleLongs, int flags, long memCapBytes) {
        boolean valid;
        boolean empty = (flags & 4) > 0;
        int minPre = Family.QUANTILES.getMinPreLongs();
        int maxPre = Family.QUANTILES.getMaxPreLongs();
        boolean bl = valid = preambleLongs == minPre && empty || preambleLongs == maxPre && !empty;
        if (!valid) {
            throw new SketchesArgumentException("Possible corruption: PreambleLongs inconsistent with empty state: " + preambleLongs);
        }
        Util.checkHeapFlags(flags);
        if (memCapBytes < (long)(preambleLongs << 3)) {
            throw new SketchesArgumentException("Possible corruption: Insufficient capacity for preamble: " + memCapBytes);
        }
        return empty;
    }

    static void checkHeapFlags(int flags) {
        int allowedFlags = 30;
        int flagsMask = -31;
        if ((flags & 0xFFFFFFE1) > 0) {
            throw new SketchesArgumentException("Possible corruption: Invalid flags field: " + Integer.toBinaryString(flags));
        }
    }

    static boolean checkIsCompactMemory(Memory srcMem) {
        int flags = PreambleUtil.extractFlags(srcMem);
        int compactFlags = 10;
        return (flags & 0xA) > 0;
    }

    static final void checkSplitPointsOrder(double[] values) {
        if (values == null) {
            throw new SketchesArgumentException("Values cannot be null.");
        }
        int lenM1 = values.length - 1;
        for (int j = 0; j < lenM1; ++j) {
            if (values[j] < values[j + 1]) continue;
            throw new SketchesArgumentException("Values must be unique, monotonically increasing and not NaN.");
        }
    }

    static final void checkFractionalRankBounds(double frank) {
        if (frank < 0.0 || frank > 1.0) {
            throw new SketchesArgumentException("Fractional rank must be >= 0 and <= 1.0: " + frank);
        }
    }

    static int computeRetainedItems(int k, long n) {
        int bbCnt = Util.computeBaseBufferItems(k, n);
        long bitPattern = Util.computeBitPattern(k, n);
        int validLevels = Util.computeValidLevels(bitPattern);
        return bbCnt + validLevels * k;
    }

    static int computeCombinedBufferItemCapacity(int k, long n) {
        int totLevels = Util.computeNumLevelsNeeded(k, n);
        if (totLevels == 0) {
            int bbItems = Util.computeBaseBufferItems(k, n);
            return Math.max(4, org.apache.datasketches.Util.ceilingPowerOf2(bbItems));
        }
        return (2 + totLevels) * k;
    }

    static int computeValidLevels(long bitPattern) {
        return Long.bitCount(bitPattern);
    }

    static int computeTotalLevels(long bitPattern) {
        return Util.hiBitPos(bitPattern) + 1;
    }

    static int computeNumLevelsNeeded(int k, long n) {
        return 1 + Util.hiBitPos(n / (2L * (long)k));
    }

    static int computeBaseBufferItems(int k, long n) {
        return (int)(n % (2L * (long)k));
    }

    static long computeBitPattern(int k, long n) {
        return n / (2L * (long)k);
    }

    static double lg(double x) {
        return Math.log(x) / Math.log(2.0);
    }

    static int hiBitPos(long num) {
        return 63 - Long.numberOfLeadingZeros(num);
    }

    static int lowestZeroBitStartingAt(long bits, int startingBit) {
        int pos = startingBit & 0x3F;
        long myBits = bits >>> pos;
        while ((myBits & 1L) != 0L) {
            myBits >>>= 1;
            ++pos;
        }
        return pos;
    }
}

