/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper.server.config;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String ZOOKEEPER_PORT = "org.apache.cxf.dosgi.discovery.zookeeper.port";
    private static final String PID = "org.apache.cxf.dosgi.discovery.zookeeper.server";
    private ServiceTracker st;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        String string = "hi";
        synchronized ("hi") {
            if (System.getProperty(ZOOKEEPER_PORT) == null) {
                String port = this.getFreePort();
                System.setProperty(ZOOKEEPER_PORT, port);
                System.out.println("Set global zookeeper port to: " + port);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.st = new ServiceTracker(context, ConfigurationAdmin.class.getName(), null){

                public Object addingService(ServiceReference reference) {
                    Object svc = super.addingService(reference);
                    if (svc instanceof ConfigurationAdmin) {
                        try {
                            ConfigurationAdmin cadmin = (ConfigurationAdmin)svc;
                            Configuration cfg = cadmin.getConfiguration(Activator.PID, null);
                            Hashtable<String, String> props = new Hashtable<String, String>();
                            String zp = System.getProperty(Activator.ZOOKEEPER_PORT);
                            props.put("clientPort", zp);
                            cfg.update(props);
                            System.out.println("Set zookeeper client port to " + zp);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return svc;
                }
            };
            this.st.open();
            ServiceReference[] refs = context.getServiceReferences(ManagedService.class.getName(), "(service.pid=org.apache.cxf.dosgi.discovery.zookeeper)");
            if (refs == null || refs.length == 0) {
                throw new RuntimeException("This bundle must be started after the bundle with the Zookeeper Discovery Managed Service was started.");
            }
            Object svc = context.getService(refs[0]);
            ManagedService ms = (ManagedService)svc;
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("zookeeper.host", "127.0.0.1");
            props.put("zookeeper.port", System.getProperty(ZOOKEEPER_PORT));
            ms.updated(props);
            System.out.println("Set the zookeeper.host on the Zookeeper Client managed service.");
            return;
        }
    }

    private String getFreePort() {
        try {
            ServerSocket ss = new ServerSocket(0);
            String port = "" + ss.getLocalPort();
            ss.close();
            return port;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.st.close();
    }
}

