/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.testutil.common.AbstractClientServerTestBase;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class AbstractBusClientServerTestBase
extends AbstractClientServerTestBase {
    protected static Bus staticBus;
    protected Bus bus;

    public void createBus(String config) throws Exception {
        this.bus = config != null ? new SpringBusFactory().createBus(config) : BusFactory.newInstance().createBus();
        BusFactory.setDefaultBus((Bus)this.bus);
    }

    public void createBus() throws Exception {
        this.createBus(null);
    }

    public static Bus getStaticBus() {
        return staticBus;
    }

    public static Bus createStaticBus(String config) {
        staticBus = config != null ? new SpringBusFactory().createBus(config) : BusFactory.newInstance().createBus();
        BusFactory.setDefaultBus((Bus)staticBus);
        return staticBus;
    }

    public static Bus createStaticBus() {
        return AbstractBusClientServerTestBase.createStaticBus(null);
    }

    @After
    public void deleteBus() throws Exception {
        if (null != this.bus) {
            this.bus.shutdown(true);
            this.bus = null;
        }
    }

    @AfterClass
    public static void deleteStaticBus() throws Exception {
        if (null != staticBus) {
            staticBus.shutdown(true);
            staticBus = null;
        }
    }

    protected Bus getBus() {
        if (this.bus == null) {
            return staticBus;
        }
        return this.bus;
    }

    protected void setBus(Bus b) {
        this.bus = b;
    }

    protected HttpURLConnection getHttpConnection(String target) throws Exception {
        URL url = new URL(target);
        URLConnection connection = url.openConnection();
        Assert.assertTrue((boolean)(connection instanceof HttpURLConnection));
        return (HttpURLConnection)connection;
    }

    protected boolean runClient(Runnable clientImpl, long timeOut, TimeUnit timeUnit) throws InterruptedException {
        FutureTask<Object> client = new FutureTask<Object>(clientImpl, null);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        tpe.execute(client);
        tpe.shutdown();
        tpe.awaitTermination(timeOut, timeUnit);
        return client.isDone();
    }
}

