/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.endpoint.Client;

public final class TestUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(TestUtil.class);
    private static int portNum = -1;
    private static Properties ports = new Properties();
    private static ServerSocket lock;

    private TestUtil() {
    }

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getClassPath(ClassLoader loader) throws URISyntaxException {
        StringBuffer classPath = new StringBuffer();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                String file = url.getFile();
                if (file.indexOf("junit") != -1) continue;
                classPath.append(url.toURI().getPort());
                classPath.append(System.getProperty("path.separator"));
            }
        }
        return classPath.toString();
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method[] declMethods;
        for (Method method : declMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Properties getAllPorts() {
        return ports;
    }

    public static String getPortNumber(Class<?> cls) {
        return TestUtil.getPortNumber(cls.getName(), cls.getSimpleName());
    }

    public static String getPortNumber(Class<?> cls, int count) {
        return TestUtil.getPortNumber(cls.getName() + "." + count, cls.getSimpleName() + "." + count);
    }

    public static String getPortNumber(String name) {
        return TestUtil.getPortNumber(name, name);
    }

    public static String getNewPortNumber(Class<?> cls) {
        return TestUtil.getNewPortNumber(cls.getName(), cls.getSimpleName());
    }

    public static String getNewPortNumber(Class<?> cls, int count) {
        return TestUtil.getNewPortNumber(cls.getName() + "." + count, cls.getSimpleName() + "." + count);
    }

    public static String getNewPortNumber(String name) {
        return TestUtil.getNewPortNumber(name, name);
    }

    private static void applyNames(String fullName, String simpleName, String p) {
        ports.setProperty("testutil.ports." + fullName, p);
        ports.setProperty("testutil.ports." + simpleName, p);
        System.setProperty("testutil.ports." + fullName, p);
        System.setProperty("testutil.ports." + simpleName, p);
        if (fullName.endsWith("." + simpleName)) {
            int idx = fullName.lastIndexOf(46, fullName.lastIndexOf(46));
            while (idx != -1) {
                String name = fullName.substring(idx + 1);
                ports.setProperty("testutil.ports." + name, p);
                System.setProperty("testutil.ports." + name, p);
                idx = fullName.lastIndexOf(46, idx - 1);
            }
        }
    }

    private static void removeNames(String fullName, String simpleName) {
        ports.remove("testutil.ports." + fullName);
        ports.remove("testutil.ports." + simpleName);
        System.clearProperty("testutil.ports." + fullName);
        System.clearProperty("testutil.ports." + simpleName);
        if (fullName.endsWith("." + simpleName)) {
            int idx = fullName.lastIndexOf(46, fullName.lastIndexOf(46));
            while (idx != -1) {
                String name = fullName.substring(idx + 1);
                ports.remove("testutil.ports." + name);
                System.clearProperty("testutil.ports." + name);
                idx = fullName.lastIndexOf(46, idx - 1);
            }
        }
    }

    public static String getNewPortNumber(String fullName, String simpleName) {
        TestUtil.removeNames(fullName, simpleName);
        return TestUtil.getPortNumber(fullName, simpleName);
    }

    public static String getPortNumber(String fullName, String simpleName) {
        String p = ports.getProperty("testutil.ports." + fullName);
        if (p == null && (p = System.getProperty("testutil.ports." + fullName)) != null) {
            ports.setProperty("testutil.ports." + fullName, p);
            ports.setProperty("testutil.ports." + simpleName, p);
        }
        while (p == null) {
            ++portNum;
            try {
                int pn;
                ServerSocket sock = new ServerSocket(pn);
                sock.close();
                p = Integer.toString(pn);
                LOG.fine("Setting port for " + fullName + " to " + p);
            }
            catch (IOException ex) {}
        }
        TestUtil.applyNames(fullName, simpleName, p);
        return p;
    }

    public static void updateAddressPort(Object o, String port) throws NumberFormatException, MalformedURLException {
        TestUtil.updateAddressPort(o, Integer.parseInt(port));
    }

    public static void updateAddressPort(Object o, int port) throws MalformedURLException {
        String address = null;
        if (o instanceof BindingProvider) {
            address = ((BindingProvider)o).getRequestContext().get("javax.xml.ws.service.endpoint.address").toString();
        } else if (o instanceof Client) {
            Client c = (Client)o;
            address = c.getEndpoint().getEndpointInfo().getAddress();
        }
        if (address != null && address.startsWith("http")) {
            URL url = new URL(address);
            url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
            TestUtil.setAddress(o, url.toString());
        }
    }

    public static void setAddress(Object o, String address) {
        if (o instanceof BindingProvider) {
            ((BindingProvider)o).getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        }
        Client c = null;
        if (o instanceof Client) {
            c = (Client)o;
        }
        if (c == null) {
            try {
                InvocationHandler i = Proxy.getInvocationHandler(o);
                c = (Client)i.getClass().getMethod("getClient", new Class[0]).invoke((Object)i, new Object[0]);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                Method m = o.getClass().getDeclaredMethod("getClient", new Class[0]);
                ReflectionUtil.setAccessible((AccessibleObject)m);
                c = (Client)m.invoke(o, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (c != null) {
            c.getEndpoint().getEndpointInfo().setAddress(address);
        }
    }

    static {
        int pn = 9000;
        if (Boolean.getBoolean("cxf.useRandomFirstPort")) {
            pn += new Random().nextInt(500) * 100;
        }
        while (portNum == -1) {
            try {
                ServerSocket sock;
                lock = sock = new ServerSocket(pn);
                portNum = pn + 1;
            }
            catch (IOException ex) {
                pn += 100;
            }
        }
    }
}

