/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_undertow.blueprint;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.jsse.TLSServerParametersConfig;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.http_undertow.CXFUndertowHttpHandler;
import org.apache.cxf.transport.http_undertow.ThreadingParameters;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngine;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transports.http_undertow.configuration.TLSServerParametersIdentifiedType;
import org.apache.cxf.transports.http_undertow.configuration.ThreadingParametersIdentifiedType;
import org.apache.cxf.transports.http_undertow.configuration.ThreadingParametersType;
import org.apache.cxf.transports.http_undertow.configuration.UndertowHTTPServerEngineConfigType;
import org.apache.cxf.transports.http_undertow.configuration.UndertowHTTPServerEngineFactoryConfigType;
import org.w3c.dom.Element;

public class UndertowHTTPServerEngineFactoryHolder {
    private static final Logger LOG = LogUtils.getL7dLogger(UndertowHTTPServerEngineFactoryHolder.class);
    private String parsedElement;
    private UndertowHTTPServerEngineFactory factory;
    private Map<String, List<CXFUndertowHttpHandler>> handlersMap;
    private JAXBContext jaxbContext;
    private Set<Class<?>> jaxbClasses;

    public void init() {
        try {
            Element element = StaxUtils.read((Reader)new StringReader(this.parsedElement)).getDocumentElement();
            UndertowHTTPServerEngineFactoryConfigType config = this.getJaxbObject(element, UndertowHTTPServerEngineFactoryConfigType.class);
            this.factory = new UndertowHTTPServerEngineFactory();
            TreeMap<String, ThreadingParameters> threadingParametersMap = new TreeMap<String, ThreadingParameters>();
            if (config.getIdentifiedThreadingParameters() != null) {
                for (ThreadingParametersIdentifiedType threadingParametersIdentifiedType : config.getIdentifiedThreadingParameters()) {
                    ThreadingParameters rThreads = new ThreadingParameters();
                    String id = threadingParametersIdentifiedType.getId();
                    rThreads.setMaxThreads(threadingParametersIdentifiedType.getThreadingParameters().getMaxThreads());
                    rThreads.setMinThreads(threadingParametersIdentifiedType.getThreadingParameters().getMinThreads());
                    rThreads.setWorkerIOThreads(threadingParametersIdentifiedType.getThreadingParameters().getWorkerIOThreads());
                    threadingParametersMap.put(id, rThreads);
                }
                this.factory.setThreadingParametersMap(threadingParametersMap);
            }
            TreeMap<String, TLSServerParameters> sslMap = new TreeMap<String, TLSServerParameters>();
            if (config.getIdentifiedTLSServerParameters() != null) {
                for (TLSServerParametersIdentifiedType t : config.getIdentifiedTLSServerParameters()) {
                    try {
                        TLSServerParametersConfig parameter = new TLSServerParametersConfig(t.getTlsServerParameters());
                        sslMap.put(t.getId(), (TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for id " + t.getId(), e);
                    }
                }
                this.factory.setTlsServerParametersMap(sslMap);
            }
            ArrayList<UndertowHTTPServerEngine> arrayList = new ArrayList<UndertowHTTPServerEngine>();
            for (UndertowHTTPServerEngineConfigType engine : config.getEngine()) {
                UndertowHTTPServerEngine eng = new UndertowHTTPServerEngine();
                if (engine.getHandlers() != null && this.handlersMap != null) {
                    List<CXFUndertowHttpHandler> handlers = this.handlersMap.get(engine.getPort().toString());
                    if (handlers != null) {
                        eng.setHandlers(handlers);
                    } else {
                        throw new RuntimeException("Could not find the handlers instance for engine with port" + engine.getPort().toString());
                    }
                }
                if (engine.isContinuationsEnabled() != null) {
                    eng.setContinuationsEnabled(engine.isContinuationsEnabled());
                }
                if (engine.getHost() != null && !StringUtils.isEmpty((String)engine.getHost())) {
                    eng.setHost(engine.getHost());
                }
                if (engine.getMaxIdleTime() != null) {
                    eng.setMaxIdleTime(engine.getMaxIdleTime());
                }
                if (engine.getPort() != null) {
                    eng.setPort(engine.getPort());
                }
                if (engine.getThreadingParameters() != null) {
                    ThreadingParametersType threads = engine.getThreadingParameters();
                    ThreadingParameters rThreads = new ThreadingParameters();
                    rThreads.setMaxThreads(threads.getMaxThreads());
                    rThreads.setMinThreads(threads.getMinThreads());
                    rThreads.setWorkerIOThreads(threads.getWorkerIOThreads());
                    eng.setThreadingParameters(rThreads);
                }
                if (engine.getTlsServerParameters() != null) {
                    TLSServerParametersConfig parameter = null;
                    try {
                        parameter = new TLSServerParametersConfig(engine.getTlsServerParameters());
                        eng.setTlsServerParameters((TLSServerParameters)parameter);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not configure TLS for engine on  " + eng.getHost() + ":" + eng.getPort(), e);
                    }
                }
                eng.finalizeConfig();
                arrayList.add(eng);
            }
            this.factory.setEnginesList(arrayList);
            this.factory.initComplete();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process configuration.", e);
        }
    }

    public void destroy() {
        this.factory.postShutdown();
        this.jaxbClasses.clear();
        this.jaxbContext = null;
    }

    public String getParsedElement() {
        return this.parsedElement;
    }

    public void setParsedElement(String parsedElement) {
        this.parsedElement = parsedElement;
    }

    protected <T> T getJaxbObject(Element parent, Class<T> c) {
        try {
            JAXBElement ele = JAXBUtils.unmarshall((JAXBContext)this.getContext(c), (Element)parent, c);
            return (T)ele.getValue();
        }
        catch (JAXBException e) {
            LOG.warning("Unable to parse property due to " + (Object)((Object)e));
            return null;
        }
    }

    protected synchronized JAXBContext getContext(Class<?> cls) {
        if (this.jaxbContext == null || this.jaxbClasses == null || !this.jaxbClasses.contains(cls)) {
            try {
                HashSet tmp = new HashSet();
                if (this.jaxbClasses != null) {
                    tmp.addAll(this.jaxbClasses);
                }
                JAXBContextCache.addPackage(tmp, (String)PackageUtils.getPackageName(cls), (ClassLoader)(cls == null ? this.getClass().getClassLoader() : cls.getClassLoader()));
                if (cls != null) {
                    boolean hasOf = false;
                    for (Class clazz : tmp) {
                        if (clazz.getPackage() != cls.getPackage() || !"ObjectFactory".equals(clazz.getSimpleName())) continue;
                        hasOf = true;
                    }
                    if (!hasOf) {
                        tmp.add(cls);
                    }
                }
                JAXBContextCache.scanPackages(tmp);
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(tmp, null, null, null, (boolean)false);
                this.jaxbClasses = ccs.getClasses();
                this.jaxbContext = ccs.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jaxbContext;
    }
}

