/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.parse;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserApplication;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.swagger.parse.ParseConfiguration;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public final class SwaggerParseUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final Map<String, Class<?>> SWAGGER_TYPE_MAP = new HashMap();

    private SwaggerParseUtils() {
    }

    public static UserApplication getUserApplication(String loc) {
        return SwaggerParseUtils.getUserApplication(loc, BusFactory.getThreadDefaultBus());
    }

    public static UserApplication getUserApplication(String loc, Bus bus) {
        return SwaggerParseUtils.getUserApplication(loc, bus, new ParseConfiguration());
    }

    public static UserApplication getUserApplication(String loc, Bus bus, ParseConfiguration cfg) {
        try {
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)bus);
            if (is == null) {
                return null;
            }
            return SwaggerParseUtils.getUserApplicationFromStream(is, cfg);
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc);
            return null;
        }
    }

    public static UserApplication getUserApplicationFromStream(InputStream is) throws IOException {
        return SwaggerParseUtils.getUserApplicationFromStream(is, new ParseConfiguration());
    }

    public static UserApplication getUserApplicationFromStream(InputStream is, ParseConfiguration cfg) throws IOException {
        return SwaggerParseUtils.getUserApplicationFromJson(IOUtils.readStringFromStream((InputStream)is), cfg);
    }

    public static UserApplication getUserApplicationFromJson(String json) {
        return SwaggerParseUtils.getUserApplicationFromJson(json, new ParseConfiguration());
    }

    public static UserApplication getUserApplicationFromJson(String json, ParseConfiguration cfg) {
        JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
        Map map = reader.fromJson(json);
        UserApplication app = new UserApplication();
        String relativePath = (String)map.get("basePath");
        app.setBasePath(StringUtils.isEmpty((String)relativePath) ? "/" : relativePath);
        LinkedHashMap userOpsMap = new LinkedHashMap();
        HashSet<String> tags = new HashSet<String>();
        List tagsProp = CastUtils.cast((List)((List)map.get("tags")));
        if (tagsProp != null) {
            for (Map map2 : tagsProp) {
                tags.add((String)map2.get("name"));
            }
        } else {
            tags.add("");
        }
        for (String string : tags) {
            userOpsMap.put(string, new LinkedList());
        }
        Map paths = CastUtils.cast((Map)((Map)map.get("paths")));
        for (Map.Entry entry : paths.entrySet()) {
            String operPath = (String)entry.getKey();
            Map operations = (Map)entry.getValue();
            for (Map.Entry operEntry : operations.entrySet()) {
                List<String> opTags;
                UserOperation userOp = new UserOperation();
                userOp.setVerb(((String)operEntry.getKey()).toUpperCase());
                Map oper = CastUtils.cast((Map)((Map)operEntry.getValue()));
                userOp.setPath(operPath);
                userOp.setName((String)oper.get("operationId"));
                List opProduces = CastUtils.cast((List)((List)oper.get("produces")));
                userOp.setProduces(SwaggerParseUtils.listToString(opProduces));
                List opConsumes = CastUtils.cast((List)((List)oper.get("consumes")));
                userOp.setConsumes(SwaggerParseUtils.listToString(opConsumes));
                LinkedList<Parameter> userOpParams = new LinkedList<Parameter>();
                List params = CastUtils.cast((List)((List)oper.get("parameters")));
                for (Map param : params) {
                    String name = (String)param.get("name");
                    String paramType = (String)param.get("in");
                    ParameterType pType = "body".equals(paramType) ? ParameterType.REQUEST_BODY : ("formData".equals(paramType) ? ParameterType.FORM : ParameterType.valueOf((String)paramType.toUpperCase()));
                    Parameter userParam = new Parameter(pType, name);
                    SwaggerParseUtils.setJavaType(userParam, (String)param.get("type"));
                    userOpParams.add(userParam);
                }
                if (!userOpParams.isEmpty()) {
                    userOp.setParameters(userOpParams);
                }
                if ((opTags = CastUtils.cast((List)((List)oper.get("tags")))) == null) {
                    opTags = Collections.singletonList("");
                }
                for (String opTag : opTags) {
                    ((List)userOpsMap.get(opTag)).add(userOp);
                }
            }
        }
        LinkedList<UserResource> linkedList = new LinkedList<UserResource>();
        for (Map.Entry entry : userOpsMap.entrySet()) {
            UserResource ur = new UserResource();
            ur.setPath("/");
            ur.setOperations((List)entry.getValue());
            ur.setName((String)entry.getKey());
            linkedList.add(ur);
        }
        app.setResources(linkedList);
        return app;
    }

    private static void setJavaType(Parameter userParam, String typeName) {
        Class javaType = SWAGGER_TYPE_MAP.get(typeName);
        if (javaType == null) {
            try {
                javaType = ClassLoaderUtils.loadClass((String)typeName, SwaggerParseUtils.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        userParam.setJavaType(javaType);
    }

    private static String listToString(List<String> list) {
        if (list != null) {
            return String.join((CharSequence)",", list);
        }
        return null;
    }

    static {
        SWAGGER_TYPE_MAP.put("string", String.class);
        SWAGGER_TYPE_MAP.put("integer", Long.TYPE);
        SWAGGER_TYPE_MAP.put("float", Float.TYPE);
        SWAGGER_TYPE_MAP.put("double", Double.TYPE);
        SWAGGER_TYPE_MAP.put("int", Integer.TYPE);
        SWAGGER_TYPE_MAP.put("long", Long.TYPE);
        SWAGGER_TYPE_MAP.put("byte", Byte.TYPE);
        SWAGGER_TYPE_MAP.put("boolean", Boolean.TYPE);
        SWAGGER_TYPE_MAP.put("date", Date.class);
        SWAGGER_TYPE_MAP.put("dateTime", Date.class);
        SWAGGER_TYPE_MAP.put("File", InputStream.class);
        SWAGGER_TYPE_MAP.put("file", InputStream.class);
    }
}

