/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.openapi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.swagger.openapi.OpenApiConfiguration;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public final class SwaggerToOpenApiConversionUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SwaggerToOpenApiConversionUtils.class);
    private static final List<String> SIMPLE_TYPE_RELATED_PROPS = Arrays.asList("format", "minimum", "maximum", "default");

    private SwaggerToOpenApiConversionUtils() {
    }

    public static String getOpenApiFromSwaggerLoc(String loc) {
        return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerLoc(loc, null);
    }

    public static String getOpenApiFromSwaggerLoc(String loc, OpenApiConfiguration cfg) {
        return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerLoc(loc, cfg, BusFactory.getThreadDefaultBus());
    }

    public static String getOpenApiFromSwaggerLoc(String loc, OpenApiConfiguration cfg, Bus bus) {
        try {
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)bus);
            if (is == null) {
                return null;
            }
            return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerStream(is, cfg);
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc + ", exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
            return null;
        }
    }

    public static String getOpenApiFromSwaggerStream(InputStream is) throws IOException {
        return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerStream(is, null);
    }

    public static String getOpenApiFromSwaggerStream(InputStream is, OpenApiConfiguration cfg) throws IOException {
        return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerJson(null, IOUtils.readStringFromStream((InputStream)is), cfg);
    }

    public static String getOpenApiFromSwaggerJson(String json) throws IOException {
        return SwaggerToOpenApiConversionUtils.getOpenApiFromSwaggerJson(null, json, null);
    }

    public static String getOpenApiFromSwaggerJson(MessageContext ctx, String json, OpenApiConfiguration cfg) throws IOException {
        List tagsObject;
        JsonMapObjectReaderWriter readerWriter = new JsonMapObjectReaderWriter();
        JsonMapObject sw2 = readerWriter.fromJsonToJsonObject(json);
        JsonMapObject sw3 = new JsonMapObject();
        sw3.setProperty("openapi", (Object)"3.0.0");
        SwaggerToOpenApiConversionUtils.setServersProperty(ctx, sw2, sw3);
        JsonMapObject infoObject = sw2.getJsonMapProperty("info");
        if (infoObject != null) {
            sw3.setProperty("info", (Object)infoObject);
        }
        if ((tagsObject = sw2.getListMapProperty("tags")) != null) {
            sw3.setProperty("tags", (Object)tagsObject);
        }
        LinkedHashMap<String, JsonMapObject> requestBodies = cfg != null && cfg.isCreateRequestBodies() ? new LinkedHashMap<String, JsonMapObject>() : null;
        SwaggerToOpenApiConversionUtils.setPathsProperty(sw2, sw3, requestBodies);
        SwaggerToOpenApiConversionUtils.setComponentsProperty(sw2, sw3, requestBodies);
        Object externalDocsObject = sw2.getProperty("externalDocs");
        if (externalDocsObject != null) {
            sw3.setProperty("externalDocs", externalDocsObject);
        }
        return readerWriter.toJson(sw3).replace("#/definitions/", "#/components/schemas/");
    }

    private static void setComponentsProperty(JsonMapObject sw2, JsonMapObject sw3, Map<String, JsonMapObject> requestBodies) {
        JsonMapObject s2SecurityDefs;
        JsonMapObject comps = new JsonMapObject();
        JsonMapObject requestBodiesObj = new JsonMapObject();
        if (requestBodies != null) {
            for (Map.Entry<String, JsonMapObject> entry : requestBodies.entrySet()) {
                requestBodiesObj.setProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        comps.setProperty("requestBodies", (Object)requestBodiesObj);
        Object s2Defs = sw2.getProperty("definitions");
        if (s2Defs != null) {
            comps.setProperty("schemas", s2Defs);
        }
        if ((s2SecurityDefs = sw2.getJsonMapProperty("securityDefinitions")) != null) {
            comps.setProperty("securitySchemes", (Object)s2SecurityDefs);
            for (String property : s2SecurityDefs.asMap().keySet()) {
                JsonMapObject securityScheme = s2SecurityDefs.getJsonMapProperty(property);
                if (!"basic".equals(securityScheme.getStringProperty("type"))) continue;
                securityScheme.setProperty("type", (Object)"http");
                securityScheme.setProperty("scheme", (Object)"basic");
            }
        }
        sw3.setProperty("components", (Object)comps);
    }

    private static void setPathsProperty(JsonMapObject sw2, JsonMapObject sw3, Map<String, JsonMapObject> requestBodies) {
        JsonMapObject sw2Paths = sw2.getJsonMapProperty("paths");
        for (Map.Entry sw2PathEntries : sw2Paths.asMap().entrySet()) {
            JsonMapObject sw2PathVerbs = new JsonMapObject(CastUtils.cast((Map)((Map)sw2PathEntries.getValue())));
            for (Map.Entry sw2PathVerbEntries : sw2PathVerbs.asMap().entrySet()) {
                JsonMapObject sw2PathVerbProps = new JsonMapObject(CastUtils.cast((Map)((Map)sw2PathVerbEntries.getValue())));
                SwaggerToOpenApiConversionUtils.prepareRequestBody(sw2PathVerbProps, requestBodies);
                SwaggerToOpenApiConversionUtils.prepareResponses(sw2PathVerbProps);
            }
        }
        sw3.setProperty("paths", (Object)sw2Paths);
    }

    private static void prepareResponses(JsonMapObject sw2PathVerbProps) {
        List sw2PathVerbProduces = CastUtils.cast((List)((List)sw2PathVerbProps.removeProperty("produces")));
        JsonMapObject sw3PathVerbResps = null;
        JsonMapObject sw2PathVerbResps = sw2PathVerbProps.getJsonMapProperty("responses");
        if (sw2PathVerbResps != null) {
            sw3PathVerbResps = new JsonMapObject();
            JsonMapObject okResp = null;
            if (sw2PathVerbResps.containsProperty("200")) {
                JsonMapObject headers;
                JsonMapObject content;
                JsonMapObject schema;
                okResp = new JsonMapObject(CastUtils.cast((Map)((Map)sw2PathVerbResps.removeProperty("200"))));
                JsonMapObject newOkResp = new JsonMapObject();
                String description = okResp.getStringProperty("description");
                if (description != null) {
                    newOkResp.setProperty("description", (Object)description);
                }
                if ((schema = okResp.getJsonMapProperty("schema")) != null && (content = SwaggerToOpenApiConversionUtils.prepareContentFromSchema(schema, sw2PathVerbProduces, false)) != null) {
                    newOkResp.setProperty("content", (Object)content);
                }
                if ((headers = okResp.getJsonMapProperty("headers")) != null) {
                    newOkResp.setProperty("headers", (Object)headers);
                }
                sw3PathVerbResps.setProperty("200", (Object)newOkResp);
            }
            for (Map.Entry entry : sw2PathVerbResps.asMap().entrySet()) {
                sw3PathVerbResps.setProperty((String)entry.getKey(), entry.getValue());
            }
            sw2PathVerbProps.setProperty("responses", (Object)sw3PathVerbResps);
        }
    }

    private static void prepareRequestBody(JsonMapObject sw2PathVerbProps, Map<String, JsonMapObject> requestBodies) {
        List sw2PathVerbConsumes = CastUtils.cast((List)((List)sw2PathVerbProps.removeProperty("consumes")));
        JsonMapObject sw3RequestBody = null;
        LinkedList<JsonMapObject> sw3formBody = null;
        List sw2PathVerbParamsList = sw2PathVerbProps.getListMapProperty("parameters");
        if (sw2PathVerbParamsList != null) {
            Iterator it = sw2PathVerbParamsList.iterator();
            while (it.hasNext()) {
                JsonMapObject schema;
                JsonMapObject sw2PathVerbParamMap = new JsonMapObject((Map)it.next());
                if ("body".equals(sw2PathVerbParamMap.getStringProperty("in"))) {
                    JsonMapObject content;
                    Boolean required;
                    it.remove();
                    sw3RequestBody = new JsonMapObject();
                    String description = sw2PathVerbParamMap.getStringProperty("description");
                    if (description != null) {
                        sw3RequestBody.setProperty("description", (Object)description);
                    }
                    if ((required = sw2PathVerbParamMap.getBooleanProperty("required")) != null) {
                        sw3RequestBody.setProperty("required", (Object)required);
                    }
                    if ((schema = sw2PathVerbParamMap.getJsonMapProperty("schema")) == null || (content = SwaggerToOpenApiConversionUtils.prepareContentFromSchema(schema, sw2PathVerbConsumes, requestBodies != null)) == null) continue;
                    sw3RequestBody.setProperty("content", (Object)content);
                    continue;
                }
                if ("formData".equals(sw2PathVerbParamMap.getStringProperty("in"))) {
                    it.remove();
                    if (sw3formBody == null) {
                        sw3formBody = new LinkedList<JsonMapObject>();
                        sw3RequestBody = new JsonMapObject();
                    }
                    sw2PathVerbParamMap.removeProperty("in");
                    sw2PathVerbParamMap.removeProperty("required");
                    sw3formBody.add(sw2PathVerbParamMap);
                    continue;
                }
                if ("array".equals(sw2PathVerbParamMap.getStringProperty("type"))) {
                    sw2PathVerbParamMap.removeProperty("type");
                    sw2PathVerbParamMap.removeProperty("collectionFormat");
                    sw2PathVerbParamMap.setProperty("explode", (Object)true);
                    JsonMapObject items = sw2PathVerbParamMap.getJsonMapProperty("items");
                    sw2PathVerbParamMap.removeProperty("items");
                    JsonMapObject schema2 = new JsonMapObject();
                    schema2.setProperty("type", (Object)"array");
                    schema2.setProperty("items", (Object)items);
                    sw2PathVerbParamMap.setProperty("schema", (Object)schema2);
                    continue;
                }
                if ("matrix".equals(sw2PathVerbParamMap.getStringProperty("in"))) {
                    sw2PathVerbParamMap.removeProperty("in");
                    sw2PathVerbParamMap.setProperty("in", (Object)"path");
                    sw2PathVerbParamMap.setProperty("style", (Object)"matrix");
                }
                String type = (String)sw2PathVerbParamMap.removeProperty("type");
                Object enumK = sw2PathVerbParamMap.removeProperty("enum");
                if (type == null) continue;
                schema = new JsonMapObject();
                schema.setProperty("type", (Object)type);
                if (enumK != null) {
                    schema.setProperty("enum", enumK);
                }
                for (String prop : SIMPLE_TYPE_RELATED_PROPS) {
                    Object value = sw2PathVerbParamMap.removeProperty(prop);
                    if (value == null) continue;
                    schema.setProperty(prop, value);
                }
                if ("password".equals(sw2PathVerbParamMap.getProperty("name"))) {
                    schema.setProperty("format", (Object)"password");
                }
                sw2PathVerbParamMap.setProperty("schema", (Object)schema);
            }
        }
        if (sw2PathVerbParamsList.isEmpty()) {
            sw2PathVerbProps.removeProperty("parameters");
        }
        if (sw3formBody != null) {
            sw3RequestBody.setProperty("content", (Object)SwaggerToOpenApiConversionUtils.prepareFormContent(sw3formBody, sw2PathVerbConsumes));
        }
        if (sw3RequestBody != null) {
            if (requestBodies == null || sw3formBody != null) {
                sw2PathVerbProps.setProperty("requestBody", sw3RequestBody);
            } else {
                String requestBodyName;
                JsonMapObject content = sw3RequestBody.getJsonMapProperty("content");
                if (content != null && (requestBodyName = (String)content.removeProperty("requestBodyName")) != null) {
                    requestBodies.put(requestBodyName, sw3RequestBody);
                    String ref = "#components/requestBodies/" + requestBodyName;
                    sw2PathVerbProps.setProperty("requestBody", Collections.singletonMap("$ref", ref));
                }
            }
        }
    }

    private static JsonMapObject prepareFormContent(List<JsonMapObject> formList, List<String> mediaTypes) {
        String mediaType = StringUtils.isEmpty(mediaTypes) ? "application/x-www-form-urlencoded" : mediaTypes.get(0);
        JsonMapObject content = new JsonMapObject();
        JsonMapObject formType = new JsonMapObject();
        JsonMapObject schema = new JsonMapObject();
        schema.setProperty("type", (Object)"object");
        JsonMapObject props = new JsonMapObject();
        for (JsonMapObject prop : formList) {
            String name = (String)prop.removeProperty("name");
            props.setProperty(name, (Object)prop);
            if (!"file".equals(prop.getProperty("type"))) continue;
            prop.setProperty("type", (Object)"string");
            if (prop.containsProperty("format")) continue;
            prop.setProperty("format", (Object)"binary");
        }
        schema.setProperty("properties", (Object)props);
        formType.setProperty("schema", (Object)schema);
        content.setProperty(mediaType, (Object)formType);
        return content;
    }

    private static JsonMapObject prepareContentFromSchema(JsonMapObject schema, List<String> mediaTypes, boolean storeModelName) {
        String type = schema.getStringProperty("type");
        String modelName = null;
        boolean isArray = false;
        if (!"object".equals(type) || !"string".equals(type)) {
            String ref = null;
            JsonMapObject items = null;
            if ("array".equals(type)) {
                isArray = true;
                items = schema.getJsonMapProperty("items");
                ref = (String)items.getProperty("$ref");
            } else {
                ref = schema.getStringProperty("$ref");
            }
            if (ref != null) {
                int index = ref.lastIndexOf("/");
                modelName = ref.substring(index + 1);
                if (items == null) {
                    schema.setProperty("$ref", (Object)("#components/schemas/" + modelName));
                } else {
                    items.setProperty("$ref", (Object)("#components/schemas/" + modelName));
                }
            }
        }
        JsonMapObject content = new JsonMapObject();
        List<String> mediaTypesList = mediaTypes == null ? Collections.singletonList("application/json") : mediaTypes;
        for (String mediaType : mediaTypesList) {
            content.setProperty(mediaType, Collections.singletonMap("schema", schema));
        }
        if (modelName != null && storeModelName) {
            content.setProperty("requestBodyName", (Object)(isArray ? modelName + "Array" : modelName));
        }
        return content;
    }

    private static void setServersProperty(MessageContext ctx, JsonMapObject sw2, JsonMapObject sw3) {
        URI requestURI = ctx == null ? null : URI.create(ctx.getHttpServletRequest().getRequestURL().toString());
        List sw2Schemes = sw2.getListStringProperty("schemes");
        String sw2Scheme = StringUtils.isEmpty((List)sw2Schemes) ? (requestURI == null ? "https" : requestURI.getScheme()) : (String)sw2Schemes.get(0);
        String sw2Host = sw2.getStringProperty("host");
        if (sw2Host == null && requestURI != null) {
            sw2Host = requestURI.getHost() + ":" + requestURI.getPort();
        }
        String sw2BasePath = sw2.getStringProperty("basePath");
        String sw3ServerUrl = sw2Scheme + "://" + sw2Host + sw2BasePath;
        sw3.setProperty("servers", Collections.singletonList(Collections.singletonMap("url", sw3ServerUrl)));
    }
}

