/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.filters;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.oauth.OAuthProblemException;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.MessageContextImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.oauth.data.OAuthContext;
import org.apache.cxf.rs.security.oauth.filters.AbstractAuthFilter;
import org.apache.cxf.rs.security.oauth.filters.OAuthInfo;
import org.apache.cxf.security.SecurityContext;

@Provider
@PreMatching
public class OAuthRequestFilter
extends AbstractAuthFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) {
        try {
            Message m = JAXRSUtils.getCurrentMessage();
            MessageContextImpl mc = new MessageContextImpl(m);
            OAuthInfo info = this.handleOAuthRequest(mc.getHttpServletRequest());
            this.setSecurityContext((MessageContext)mc, m, info);
        }
        catch (OAuthProblemException e) {
            context.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)"OAuth").build());
        }
        catch (Exception e) {
            context.abortWith(Response.status((int)401).header("WWW-Authenticate", (Object)"OAuth").build());
        }
    }

    private void setSecurityContext(MessageContext mc, Message m, OAuthInfo info) {
        SecurityContext sc = this.createSecurityContext(mc.getHttpServletRequest(), info);
        m.setContent(SecurityContext.class, (Object)sc);
        m.setContent(OAuthContext.class, (Object)this.createOAuthContext(info));
    }
}

