/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.filters;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.oauth.data.AccessToken;
import org.apache.cxf.rs.security.oauth.data.Client;
import org.apache.cxf.rs.security.oauth.data.OAuthContext;
import org.apache.cxf.rs.security.oauth.data.OAuthPermission;
import org.apache.cxf.rs.security.oauth.data.UserSubject;
import org.apache.cxf.rs.security.oauth.filters.OAuthInfo;
import org.apache.cxf.rs.security.oauth.provider.DefaultOAuthValidator;
import org.apache.cxf.rs.security.oauth.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth.utils.OAuthUtils;
import org.apache.cxf.security.SecurityContext;

public class AbstractAuthFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractAuthFilter.class);
    private static final String[] REQUIRED_PARAMETERS = new String[]{"oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce"};
    private static final Set<String> ALLOWED_OAUTH_PARAMETERS = new HashSet<String>();
    private boolean useUserSubject;
    private OAuthDataProvider dataProvider;
    private OAuthValidator validator = new DefaultOAuthValidator();

    protected AbstractAuthFilter() {
    }

    public void setDataProvider(OAuthDataProvider provider) {
        this.dataProvider = provider;
    }

    public void setUseUserSubject(boolean useUserSubject) {
        this.useUserSubject = useUserSubject;
    }

    public boolean isUseUserSubject() {
        return this.useUserSubject;
    }

    protected OAuthInfo handleOAuthRequest(HttpServletRequest req) throws Exception, OAuthProblemException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "OAuth security filter for url: {0}", req.getRequestURL());
        }
        AccessToken accessToken = null;
        Client client = null;
        OAuthMessage oAuthMessage = OAuthServlet.getMessage((HttpServletRequest)new CustomHttpServletWrapper(req), (String)OAuthServlet.getRequestURL((HttpServletRequest)req));
        if (oAuthMessage.getParameter("oauth_token") != null) {
            oAuthMessage.requireParameters(REQUIRED_PARAMETERS);
            accessToken = this.dataProvider.getAccessToken(oAuthMessage.getToken());
            if (accessToken == null) {
                LOG.warning("Access token is unavailable");
                throw new OAuthProblemException("token_rejected");
            }
            client = accessToken.getClient();
            OAuthUtils.validateMessage(oAuthMessage, client, accessToken, this.dataProvider, this.validator);
        } else {
            String consumerKey = null;
            String consumerSecret = null;
            String authHeader = oAuthMessage.getHeader("Authorization");
            if (authHeader != null) {
                AuthorizationPolicy policy;
                if (authHeader.startsWith("OAuth")) {
                    consumerKey = oAuthMessage.getParameter("oauth_consumer_key");
                    consumerSecret = oAuthMessage.getParameter("oauth_consumer_secret");
                } else if (authHeader.startsWith("Basic") && (policy = this.getAuthorizationPolicy(authHeader)) != null) {
                    consumerKey = policy.getUserName();
                    consumerSecret = policy.getPassword();
                }
            }
            if (consumerKey != null) {
                client = this.dataProvider.getClient(consumerKey);
            }
            if (client == null) {
                LOG.warning("Client is invalid");
                throw new OAuthProblemException("consumer_key_unknown");
            }
            if (consumerSecret != null && !consumerSecret.equals(client.getSecretKey())) {
                LOG.warning("Client secret is invalid");
                throw new OAuthProblemException("consumer_key_unknown");
            }
            OAuthUtils.validateMessage(oAuthMessage, client, null, this.dataProvider, this.validator);
            accessToken = client.getPreAuthorizedToken();
            if (accessToken == null || !accessToken.isPreAuthorized()) {
                LOG.warning("Preauthorized access token is unavailable");
                throw new OAuthProblemException("token_rejected");
            }
        }
        List<OAuthPermission> permissions = accessToken.getScopes();
        ArrayList<OAuthPermission> matchingPermissions = new ArrayList<OAuthPermission>();
        for (OAuthPermission perm : permissions) {
            boolean uriOK = this.checkRequestURI(req, perm.getUris());
            boolean verbOK = this.checkHttpVerb(req, perm.getHttpVerbs());
            if (!uriOK || !verbOK) continue;
            matchingPermissions.add(perm);
        }
        if (permissions.size() > 0 && matchingPermissions.isEmpty()) {
            String message = "Client has no valid permissions";
            LOG.warning(message);
            throw new OAuthProblemException(message);
        }
        return new OAuthInfo(accessToken, matchingPermissions);
    }

    protected AuthorizationPolicy getAuthorizationPolicy(String authorizationHeader) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return m != null ? (AuthorizationPolicy)m.get(AuthorizationPolicy.class) : null;
    }

    protected boolean checkHttpVerb(HttpServletRequest req, List<String> verbs) {
        if (!verbs.isEmpty() && !verbs.contains(req.getMethod())) {
            String message = "Invalid http verb";
            LOG.fine(message);
            return false;
        }
        return true;
    }

    protected boolean checkRequestURI(HttpServletRequest request, List<String> uris) {
        if (uris.isEmpty()) {
            return true;
        }
        String servletPath = request.getPathInfo();
        boolean foundValidScope = false;
        for (String uri : uris) {
            if (!OAuthUtils.checkRequestURI(servletPath, uri)) continue;
            foundValidScope = true;
            break;
        }
        if (!foundValidScope) {
            String message = "Invalid request URI: " + request.getRequestURL().toString();
            LOG.warning(message);
        }
        return foundValidScope;
    }

    protected SecurityContext createSecurityContext(HttpServletRequest request, final OAuthInfo info) {
        UserSubject subject;
        request.setAttribute("oauth_authorities", info.getRoles());
        final UserSubject theSubject = subject = info.getToken().getSubject();
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                String login = AbstractAuthFilter.this.useUserSubject ? (theSubject != null ? theSubject.getLogin() : null) : info.getToken().getClient().getLoginName();
                return new SimplePrincipal(login);
            }

            public boolean isUserInRole(String role) {
                List<String> roles = null;
                roles = AbstractAuthFilter.this.useUserSubject && theSubject != null ? theSubject.getRoles() : info.getRoles();
                return roles == null ? false : roles.contains(role);
            }
        };
    }

    protected OAuthContext createOAuthContext(OAuthInfo info) {
        UserSubject subject = null;
        if (info.getToken() != null) {
            subject = info.getToken().getSubject();
        }
        return new OAuthContext(subject, info.getMatchedPermissions());
    }

    public void setValidator(OAuthValidator validator) {
        this.validator = validator;
    }

    static {
        ALLOWED_OAUTH_PARAMETERS.addAll(Arrays.asList(REQUIRED_PARAMETERS));
        ALLOWED_OAUTH_PARAMETERS.add("oauth_version");
        ALLOWED_OAUTH_PARAMETERS.add("oauth_consumer_secret");
    }

    private static class CustomHttpServletWrapper
    extends HttpServletRequestWrapper {
        public CustomHttpServletWrapper(HttpServletRequest req) {
            super(req);
        }

        public Map<String, String[]> getParameterMap() {
            Map params = super.getParameterMap();
            if (ALLOWED_OAUTH_PARAMETERS.containsAll(params.keySet())) {
                return params;
            }
            HashMap<String, String[]> newParams = new HashMap<String, String[]>();
            for (Map.Entry entry : params.entrySet()) {
                if (!ALLOWED_OAUTH_PARAMETERS.contains(entry.getKey())) continue;
                newParams.put((String)entry.getKey(), (String[])entry.getValue());
            }
            return newParams;
        }
    }
}

