/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.client;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.core.UriBuilder;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.rs.security.oauth.provider.OAuthServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthClientUtils {
    private OAuthClientUtils() {
    }

    public static URI getAuthorizationURI(String authorizationServiceURI, String requestToken) {
        return UriBuilder.fromUri((String)authorizationServiceURI).queryParam("oauth_token", new Object[]{requestToken}).build(new Object[0]);
    }

    public static Token getRequestToken(WebClient requestTokenService, Consumer consumer, URI callback, Map<String, String> extraParams) throws OAuthServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParams != null) {
            parameters.putAll(extraParams);
        }
        parameters.put("oauth_callback", callback.toString());
        parameters.put("oauth_signature_method", "HMAC-SHA1");
        parameters.put("oauth_nonce", UUID.randomUUID().toString());
        parameters.put("oauth_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        parameters.put("oauth_consumer_key", consumer.getKey());
        OAuthConsumer oAuthConsumer = new OAuthConsumer(null, consumer.getKey(), consumer.getSecret(), null);
        OAuthAccessor accessor = new OAuthAccessor(oAuthConsumer);
        return OAuthClientUtils.getToken(requestTokenService, accessor, parameters);
    }

    public static Token getAccessToken(WebClient accessTokenService, Consumer consumer, Token requestToken, String verifier) throws OAuthServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_consumer_key", consumer.getKey());
        parameters.put("oauth_token", requestToken.getToken());
        parameters.put("oauth_verifier", verifier);
        parameters.put("oauth_signature_method", "HMAC-SHA1");
        OAuthConsumer oAuthConsumer = new OAuthConsumer(null, consumer.getKey(), consumer.getSecret(), null);
        OAuthAccessor accessor = new OAuthAccessor(oAuthConsumer);
        accessor.requestToken = requestToken.getToken();
        accessor.tokenSecret = requestToken.getSecret();
        return OAuthClientUtils.getToken(accessTokenService, accessor, parameters);
    }

    public static String createAuthorizationHeader(Consumer consumer, Token accessToken, String method, String requestURI) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_consumer_key", consumer.getKey());
        if (accessToken != null) {
            parameters.put("oauth_token", accessToken.getToken());
        }
        parameters.put("oauth_signature_method", "HMAC-SHA1");
        parameters.put("oauth_nonce", UUID.randomUUID().toString());
        parameters.put("oauth_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        OAuthConsumer oAuthConsumer = new OAuthConsumer(null, consumer.getKey(), consumer.getSecret(), null);
        OAuthAccessor accessor = new OAuthAccessor(oAuthConsumer);
        if (accessToken != null) {
            accessor.accessToken = accessToken.getToken();
            accessor.tokenSecret = accessToken.getSecret();
        }
        return OAuthClientUtils.doGetAuthorizationHeader(accessor, method, requestURI, parameters);
    }

    public static String createAuthorizationHeader(Consumer consumer) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ").append("oauth_consumer_key=").append(consumer.getKey()).append("oauth_consumer_secret=").append(consumer.getSecret());
        return sb.toString();
    }

    private static String doGetAuthorizationHeader(OAuthAccessor accessor, String method, String requestURI, Map<String, String> parameters) {
        try {
            OAuthMessage msg = accessor.newRequestMessage(method, requestURI, parameters.entrySet());
            StringBuilder sb = new StringBuilder();
            sb.append(msg.getAuthorizationHeader(null));
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getKey().startsWith("oauth_")) continue;
                sb.append(", ");
                sb.append(OAuth.percentEncode((String)entry.getKey())).append("=\"");
                sb.append(OAuth.percentEncode((String)entry.getValue())).append('\"');
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new ClientWebApplicationException((Throwable)ex);
        }
    }

    private static Token getToken(WebClient tokenService, OAuthAccessor accessor, Map<String, String> parameters) throws OAuthServiceException {
        String header = OAuthClientUtils.doGetAuthorizationHeader(accessor, "POST", tokenService.getBaseURI().toString(), parameters);
        try {
            tokenService.replaceHeader("Authorization", header);
            Form form = (Form)tokenService.post(null, Form.class);
            return new Token((String)form.getData().getFirst((Object)"oauth_token"), (String)form.getData().getFirst((Object)"oauth_token_secret"));
        }
        catch (ServerWebApplicationException ex) {
            throw new OAuthServiceException(ex);
        }
    }

    public static class Consumer {
        private String key;
        private String secret;

        public Consumer(String key, String secret) {
            this.key = key;
            this.secret = secret;
        }

        public String getKey() {
            return this.key;
        }

        public String getSecret() {
            return this.secret;
        }
    }

    public static class Token {
        private String token;
        private String secret;

        public Token(String token, String secret) {
            this.token = token;
            this.secret = secret;
        }

        public String getToken() {
            return this.token;
        }

        public String getSecret() {
            return this.secret;
        }
    }
}

