/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spring;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.configuration.spring.AbstractFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JAXRSClientFactoryBeanDefinitionParser
extends AbstractFactoryBeanDefinitionParser {
    public JAXRSClientFactoryBeanDefinitionParser() {
        this.setBeanClass(Object.class);
    }

    protected Class<?> getFactoryClass() {
        return JAXRSSpringClientFactoryBean.class;
    }

    protected String getFactoryIdSuffix() {
        return ".proxyFactory";
    }

    protected String getSuffix() {
        return ".jaxrs-client";
    }

    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addPropertyValue(name, (Object)q);
        } else if ("base-packages".equals(name)) {
            bean.addPropertyValue("basePackages", (Object)ClasspathScanner.parsePackages((String)val));
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name) || "headers".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("features".equals(name) || "providers".equals(name) || "schemaLocations".equals(name) || "modelBeans".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("model".equals(name)) {
            List resources = ResourceUtils.getResourcesFromElement((Element)el);
            bean.addPropertyValue("modelBeans", (Object)resources);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    public static class JAXRSSpringClientFactoryBean
    extends JAXRSClientFactoryBean
    implements ApplicationContextAware {
        private List<String> basePackages;

        public void setBasePackages(List<String> basePackages) {
            this.basePackages = basePackages;
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            try {
                if (this.basePackages != null) {
                    Map classes = ClasspathScanner.findClasses(this.basePackages, (Class[])new Class[]{Path.class, Provider.class});
                    if (((Collection)classes.get(Path.class)).size() > 1) {
                        throw new NoUniqueBeanDefinitionException(Path.class, ((Collection)classes.get(Path.class)).size(), "More than one service class (@Path) has been discovered");
                    }
                    for (Class providerClass : (Collection)classes.get(Provider.class)) {
                        this.setProvider(ctx.getAutowireCapableBeanFactory().createBean(providerClass));
                    }
                    for (Class serviceClass : (Collection)classes.get(Path.class)) {
                        this.setServiceClass(serviceClass);
                    }
                }
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                throw new BeanCreationException("Failed to create bean from classfile", (Throwable)ex);
            }
            if (this.bus == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus((ApplicationContext)ctx));
            }
        }
    }
}

