/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.management.interceptor.AbstractMessageResponseTimeInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class ResponseTimeMessageOutInterceptor
extends AbstractMessageResponseTimeInterceptor {
    private EndingInterceptor ending = new EndingInterceptor();

    public ResponseTimeMessageOutInterceptor() {
        super("send");
    }

    public void handleMessage(Message message) throws Fault {
        Exchange ex = message.getExchange();
        if (Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.partial.response"))) {
            return;
        }
        if (this.isClient(message)) {
            if (ex.isOneWay()) {
                message.getInterceptorChain().add((Interceptor)this.ending);
            }
            this.beginHandlingMessage(ex);
        } else {
            this.endHandlingMessage(ex);
        }
    }

    public void handleFault(Message message) {
        Exchange ex = message.getExchange();
        if (!ex.isOneWay()) {
            FaultMode faultMode = (FaultMode)message.get(FaultMode.class);
            if (faultMode == null) {
                faultMode = FaultMode.RUNTIME_FAULT;
            }
            ex.put(FaultMode.class, (Object)faultMode);
            this.endHandlingMessage(ex);
        }
    }

    EndingInterceptor getEndingInterceptor() {
        return this.ending;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EndingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public EndingInterceptor() {
            super("prepare-send-ending");
        }

        public void handleMessage(Message message) throws Fault {
            Exchange ex = message.getExchange();
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(ex);
        }

        public void handleFault(Message message) throws Fault {
            Exchange ex = message.getExchange();
            ResponseTimeMessageOutInterceptor.this.endHandlingMessage(ex);
        }
    }
}

