/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.metrics;

import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.metrics.MetricsProvider;
import org.apache.cxf.metrics.interceptors.CountingOutInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageClientOutInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageInInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageInOneWayInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageInPostInvokeInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageInPreInvokeInterceptor;
import org.apache.cxf.metrics.interceptors.MetricsMessageOutInterceptor;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class MetricsFeature
extends AbstractFeature {
    MetricsProvider[] providers;

    public MetricsFeature() {
        this.providers = null;
    }

    public MetricsFeature(MetricsProvider provider) {
        this.providers = new MetricsProvider[]{provider};
    }

    public MetricsFeature(MetricsProvider ... providers) {
        this.providers = providers.length > 0 ? providers : null;
    }

    public void initialize(Server server, Bus bus) {
        this.createDefaultProvidersIfNeeded(bus);
        Endpoint provider = server.getEndpoint();
        MetricsMessageOutInterceptor out = new MetricsMessageOutInterceptor(this.providers);
        CountingOutInterceptor countingOut = new CountingOutInterceptor();
        provider.getInInterceptors().add(new MetricsMessageInInterceptor(this.providers));
        provider.getInInterceptors().add(new MetricsMessageInOneWayInterceptor(this.providers));
        provider.getInInterceptors().add(new MetricsMessageInPreInvokeInterceptor(this.providers));
        provider.getOutInterceptors().add(countingOut);
        provider.getOutInterceptors().add(out);
        provider.getOutFaultInterceptors().add(countingOut);
        provider.getOutFaultInterceptors().add(out);
    }

    public void initialize(Client client, Bus bus) {
        this.createDefaultProvidersIfNeeded(bus);
        MetricsMessageOutInterceptor out = new MetricsMessageOutInterceptor(this.providers);
        CountingOutInterceptor countingOut = new CountingOutInterceptor();
        client.getInInterceptors().add(new MetricsMessageInInterceptor(this.providers));
        client.getInInterceptors().add(new MetricsMessageInPostInvokeInterceptor(this.providers));
        client.getInFaultInterceptors().add(new MetricsMessageInPostInvokeInterceptor(this.providers));
        client.getOutInterceptors().add(countingOut);
        client.getOutInterceptors().add(out);
        client.getOutInterceptors().add(new MetricsMessageClientOutInterceptor(this.providers));
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        this.createDefaultProvidersIfNeeded(bus);
        MetricsMessageOutInterceptor out = new MetricsMessageOutInterceptor(this.providers);
        CountingOutInterceptor countingOut = new CountingOutInterceptor();
        provider.getInInterceptors().add(new MetricsMessageInInterceptor(this.providers));
        provider.getInInterceptors().add(new MetricsMessageInOneWayInterceptor(this.providers));
        provider.getInInterceptors().add(new MetricsMessageInPreInvokeInterceptor(this.providers));
        provider.getInInterceptors().add(new MetricsMessageInPostInvokeInterceptor(this.providers));
        provider.getInFaultInterceptors().add(new MetricsMessageInPreInvokeInterceptor(this.providers));
        provider.getInFaultInterceptors().add(new MetricsMessageInPostInvokeInterceptor(this.providers));
        provider.getOutInterceptors().add(countingOut);
        provider.getOutInterceptors().add(out);
        provider.getOutInterceptors().add(new MetricsMessageClientOutInterceptor(this.providers));
        provider.getOutFaultInterceptors().add(countingOut);
        provider.getOutFaultInterceptors().add(out);
    }

    private void createDefaultProvidersIfNeeded(Bus bus) {
        Collection coll;
        ConfiguredBeanLocator b;
        if (this.providers == null && (b = (ConfiguredBeanLocator)bus.getExtension(ConfiguredBeanLocator.class)) != null && (coll = b.getBeansOfType(MetricsProvider.class)) != null) {
            this.providers = coll.toArray(new MetricsProvider[0]);
        }
        if (this.providers == null) {
            try {
                Class cls = ClassLoaderUtils.loadClass((String)"org.apache.cxf.metrics.codahale.CodahaleMetricsProvider", MetricsFeature.class);
                Constructor c = cls.getConstructor(Bus.class);
                this.providers = new MetricsProvider[]{(MetricsProvider)c.newInstance(bus)};
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

