/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace.jaxrs;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.cxf.tracing.htrace.AbstractHTraceProvider;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@Provider
public class HTraceProvider
extends AbstractHTraceProvider
implements ContainerRequestFilter,
ContainerResponseFilter {
    @Context
    private ResourceInfo resourceInfo;

    public HTraceProvider(Tracer tracer) {
        super(tracer);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        AbstractTracingProvider.TraceScopeHolder<TraceScope> holder = super.startTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), requestContext.getUriInfo().getPath(), requestContext.getMethod());
        if (holder != null) {
            requestContext.setProperty("org.apache.cxf.tracing.htrace.span", holder);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        super.stopTraceSpan((Map<String, List<String>>)requestContext.getHeaders(), (Map<String, List<Object>>)responseContext.getHeaders(), (AbstractTracingProvider.TraceScopeHolder<TraceScope>)((AbstractTracingProvider.TraceScopeHolder)requestContext.getProperty("org.apache.cxf.tracing.htrace.span")));
    }

    @Override
    protected boolean isAsyncResponse() {
        Annotation[][] annotationArray = this.resourceInfo.getResourceMethod().getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Suspended.class)) continue;
                return true;
            }
        }
        return false;
    }
}

