/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.tracing.AbstractTracingProvider;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

public abstract class AbstractHTraceProvider
extends AbstractTracingProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractHTraceProvider.class);
    protected static final String TRACE_SPAN = "org.apache.cxf.tracing.htrace.span";
    private final Tracer tracer;

    public AbstractHTraceProvider(Tracer tracer) {
        this.tracer = tracer;
    }

    protected AbstractTracingProvider.TraceScopeHolder<TraceScope> startTraceSpan(Map<String, List<String>> requestHeaders, String path, String method) {
        SpanId spanId = AbstractHTraceProvider.getFirstValueOrDefault(requestHeaders, AbstractHTraceProvider.getSpanIdHeader(), SpanId.INVALID);
        TraceScope traceScope = null;
        traceScope = SpanId.INVALID.equals((Object)spanId) ? this.tracer.newScope(this.buildSpanDescription(path, method)) : this.tracer.newScope(this.buildSpanDescription(path, method), spanId);
        boolean detached = false;
        if (this.isAsyncResponse()) {
            traceScope.detach();
            this.propagateContinuationSpan(traceScope);
            detached = true;
        }
        return new AbstractTracingProvider.TraceScopeHolder((Object)traceScope, detached);
    }

    protected void stopTraceSpan(Map<String, List<String>> requestHeaders, Map<String, List<Object>> responseHeaders, AbstractTracingProvider.TraceScopeHolder<TraceScope> holder) {
        String spanIdHeader = AbstractHTraceProvider.getSpanIdHeader();
        if (requestHeaders.containsKey(spanIdHeader)) {
            responseHeaders.put(spanIdHeader, CastUtils.cast(requestHeaders.get(spanIdHeader)));
        }
        if (holder == null) {
            return;
        }
        TraceScope span = (TraceScope)holder.getScope();
        if (span != null) {
            if (holder.isDetached()) {
                span.reattach();
                span.close();
            } else {
                span.close();
            }
        }
    }

    private void propagateContinuationSpan(TraceScope continuationScope) {
        PhaseInterceptorChain.getCurrentMessage().put(TraceScope.class, (Object)continuationScope);
    }

    protected boolean isAsyncResponse() {
        return !PhaseInterceptorChain.getCurrentMessage().getExchange().isSynchronous();
    }

    private static SpanId getFirstValueOrDefault(Map<String, List<String>> headers, String header, SpanId defaultValue) {
        List<String> value = headers.get(header);
        if (value != null && !value.isEmpty()) {
            try {
                return SpanId.fromString((String)value.get(0));
            }
            catch (NumberFormatException ex) {
                LOG.log(Level.FINE, String.format("Unable to parse '%s' header value to Span Id", header), ex);
            }
        }
        return defaultValue;
    }
}

