/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace.jaxrs;

import java.util.Arrays;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.tracing.htrace.jaxrs.HTraceContextProvider;
import org.apache.cxf.tracing.htrace.jaxrs.HTraceProvider;
import org.apache.htrace.HTraceConfiguration;
import org.apache.htrace.Sampler;
import org.apache.htrace.SamplerBuilder;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.htrace.Trace;

public class HTraceFeature
extends AbstractFeature {
    private HTraceConfiguration configuration;

    public HTraceFeature() {
        this(HTraceConfiguration.EMPTY);
    }

    public HTraceFeature(HTraceConfiguration configuration) {
        this.configuration = configuration;
    }

    public void initialize(Server server, Bus bus) {
        ServerProviderFactory providerFactory = (ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName());
        Sampler sampler = new SamplerBuilder(this.configuration).build();
        SpanReceiver spanReceiver = new SpanReceiverBuilder(this.configuration).build();
        if (spanReceiver != null) {
            Trace.addReceiver((SpanReceiver)spanReceiver);
        }
        if (providerFactory != null) {
            providerFactory.setUserProviders(Arrays.asList(new Object[]{new HTraceProvider(sampler), new HTraceContextProvider(sampler)}));
        }
    }

    public void setConfiguration(HTraceConfiguration configuration) {
        this.configuration = configuration;
    }

    public HTraceConfiguration getConfiguration() {
        return this.configuration;
    }
}

