/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing.htrace;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.cxf.tracing.Traceable;
import org.apache.cxf.tracing.TracerContext;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.wrappers.TraceCallable;

public class HTraceTracerContext
implements TracerContext {
    private final Sampler<?> sampler;

    public HTraceTracerContext(Sampler<?> sampler) {
        this.sampler = sampler;
    }

    public TraceScope startSpan(String description) {
        return Trace.startSpan((String)description, this.sampler);
    }

    public <T> Callable<T> wrap(String desription, final Traceable<T> traceable) {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                return traceable.call((TracerContext)new HTraceTracerContext(HTraceTracerContext.this.sampler));
            }
        };
        if (Trace.isTracing()) {
            return new TraceCallable(Trace.currentSpan(), callable, desription);
        }
        return callable;
    }

    public void annotate(byte[] key, byte[] value) {
        Trace.addKVAnnotation((byte[])key, (byte[])value);
    }

    public void annotate(String key, String value) {
        this.annotate(key.getBytes(StandardCharsets.UTF_8), value.getBytes(StandardCharsets.UTF_8));
    }

    public void timeline(String message) {
        Trace.addTimelineAnnotation((String)message);
    }
}

