/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.BeforeShutdown;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.cdi.AbstractCXFBean;
import org.apache.cxf.cdi.CdiBusBean;
import org.apache.cxf.cdi.CdiServerConfigurableFactory;
import org.apache.cxf.cdi.ContextProducerBean;
import org.apache.cxf.cdi.DefaultApplicationBean;
import org.apache.cxf.cdi.DelegateContextAnnotatedType;
import org.apache.cxf.cdi.Lifecycle;
import org.apache.cxf.cdi.PerRequestResourceProvider;
import org.apache.cxf.cdi.SingletonResourceProvider;
import org.apache.cxf.cdi.event.DisposableCreationalContext;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.ContextClassProvider;
import org.apache.cxf.jaxrs.ext.JAXRSServerFactoryCustomizationExtension;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.provider.ServerConfigurableFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSServerFactoryCustomizationUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class JAXRSCdiResourceExtension
implements Extension {
    private boolean hasBus;
    private Bus bus;
    private Set<Bean<?>> applicationBeans = new LinkedHashSet();
    private Set<Bean<?>> serviceBeans = new HashSet();
    private Set<Bean<?>> providerBeans = new HashSet();
    private Set<Bean<? extends Feature>> featureBeans = new HashSet<Bean<? extends Feature>>();
    private Set<Type> contextTypes = new LinkedHashSet<Type>();
    private final List<CreationalContext<?>> disposableCreationalContexts = new ArrayList();
    private final List<Lifecycle> disposableLifecycles = new ArrayList<Lifecycle>();
    private final Collection<String> existingStandardClasses = new HashSet<String>();

    public Collection<String> getExistingStandardClasses() {
        return this.existingStandardClasses;
    }

    void onStartup(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
        boolean webHandled = false;
        try {
            loader.loadClass("org.apache.webbeans.web.lifecycle.WebContainerLifecycle");
            webHandled = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
        if (!webHandled) {
            try {
                loader.loadClass("org.jboss.weld.module.web.WeldWebModule");
                webHandled = true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (webHandled) {
            this.existingStandardClasses.addAll(Arrays.asList("jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.ServletContext"));
        }
        beanManager.getEvent().fire((Object)this);
    }

    public <X> void convertContextsToCdi(@Observes @WithAnnotations(value={Context.class}) ProcessAnnotatedType<X> processAnnotatedType) {
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        DelegateContextAnnotatedType type = new DelegateContextAnnotatedType(annotatedType);
        this.contextTypes.addAll(type.getContextFieldTypes());
        processAnnotatedType.setAnnotatedType(type);
    }

    public <T> void collect(@Observes ProcessBean<T> event, BeanManager beanManager) {
        Annotated annotated = event.getAnnotated();
        if (JAXRSCdiResourceExtension.isAnnotationPresent(beanManager, annotated, ApplicationPath.class)) {
            this.applicationBeans.add(event.getBean());
        } else if (JAXRSCdiResourceExtension.isAnnotationPresent(beanManager, annotated, Path.class)) {
            this.serviceBeans.add(event.getBean());
        } else if (JAXRSCdiResourceExtension.isAnnotationPresent(beanManager, annotated, Provider.class)) {
            this.providerBeans.add(event.getBean());
        } else if (event.getBean().getTypes().contains(jakarta.ws.rs.core.Feature.class)) {
            this.providerBeans.add(event.getBean());
        } else if (event.getBean().getTypes().contains(Feature.class)) {
            this.featureBeans.add((Bean<? extends Feature>)event.getBean());
        } else if ("cxf".equals(event.getBean().getName()) && Bus.class.isAssignableFrom(event.getBean().getBeanClass())) {
            this.hasBus = true;
        } else if (event.getBean().getQualifiers().contains(AbstractCXFBean.DEFAULT)) {
            event.getBean().getTypes().stream().filter(e -> Object.class != e && InjectionUtils.STANDARD_CONTEXT_CLASSES.contains(e.getTypeName())).findFirst().ifPresent(type -> this.existingStandardClasses.add(type.getTypeName()));
        }
    }

    public <T, X> void collect(@Observes ProcessProducerField<T, X> event) {
        Type baseType = event.getAnnotatedProducerField().getBaseType();
        this.processProducer((ProcessBean<T>)event, baseType);
    }

    public <T, X> void collect(@Observes ProcessProducerMethod<T, X> event) {
        Type baseType = event.getAnnotatedProducerMethod().getBaseType();
        this.processProducer((ProcessBean<T>)event, baseType);
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        Bean busBean = beanManager.resolve(beanManager.getBeans("cxf"));
        this.bus = (Bus)beanManager.getReference(busBean, Bus.class, beanManager.createCreationalContext((Contextual)busBean));
        if (this.bus.getExtension(ServerConfigurableFactory.class) == null) {
            this.bus.setExtension((Object)new CdiServerConfigurableFactory(beanManager), ServerConfigurableFactory.class);
        }
        for (Bean<?> application : this.applicationBeans) {
            JAXRSServerFactoryBean factory;
            Application instance = (Application)beanManager.getReference(application, (Type)application.getBeanClass(), this.createCreationalContext(beanManager, application));
            if (instance.getSingletons().isEmpty() && instance.getClasses().isEmpty()) {
                factory = this.createFactoryInstance(instance, this.loadServices(beanManager, Collections.emptySet()), this.loadProviders(beanManager, Collections.emptySet()), this.loadFeatures(beanManager, Collections.emptySet()));
                this.customize(beanManager, factory);
                factory.init();
                continue;
            }
            factory = this.createFactoryInstance(instance, beanManager);
            this.customize(beanManager, factory);
            factory.init();
        }
        this.cleanStartupData();
    }

    public void injectBus(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (!this.hasBus) {
            AnnotatedType busAnnotatedType = beanManager.createAnnotatedType(ExtensionManagerBus.class);
            InjectionTarget busInjectionTarget = beanManager.createInjectionTarget(busAnnotatedType);
            event.addBean((Bean)new CdiBusBean((InjectionTarget<ExtensionManagerBus>)busInjectionTarget));
        }
        if (this.applicationBeans.isEmpty() && !this.serviceBeans.isEmpty()) {
            DefaultApplicationBean applicationBean = new DefaultApplicationBean();
            this.applicationBeans.add(applicationBean);
            event.addBean((Bean)applicationBean);
        } else {
            this.existingStandardClasses.add(Application.class.getName());
        }
        InjectionUtils.STANDARD_CONTEXT_CLASSES.stream().map(this::toClass).filter(Objects::nonNull).forEach(this.contextTypes::add);
        this.contextTypes.addAll(JAXRSCdiResourceExtension.getCustomContextClasses());
        this.contextTypes.forEach(t -> event.addBean((Bean)new ContextProducerBean((Type)t, !this.existingStandardClasses.contains(t.getTypeName()))));
    }

    private void cleanStartupData() {
        Stream.of(this.serviceBeans, this.providerBeans, this.featureBeans, this.applicationBeans, this.contextTypes).forEach(Collection::clear);
        this.serviceBeans = null;
        this.providerBeans = null;
        this.featureBeans = null;
        this.applicationBeans = null;
        this.contextTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCreationalContextForDisposal(@Observes DisposableCreationalContext event) {
        List<CreationalContext<?>> list = this.disposableCreationalContexts;
        synchronized (list) {
            this.disposableCreationalContexts.add(event.getContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(@Observes BeforeShutdown event) {
        List<CreationalContext<?>> list = this.disposableCreationalContexts;
        synchronized (list) {
            for (CreationalContext<?> disposableCreationalContext : this.disposableCreationalContexts) {
                disposableCreationalContext.release();
            }
            this.disposableCreationalContexts.clear();
        }
        this.disposableLifecycles.forEach(Lifecycle::destroy);
        this.disposableLifecycles.clear();
    }

    private Class<?> toClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, List<?> services, List<?> providers, List<? extends Feature> features) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false, (boolean)false, (Bus)this.bus);
        instance.setServiceBeans(new ArrayList(services));
        instance.setProviders(providers);
        instance.setProviders(this.loadExternalProviders());
        instance.setFeatures(features);
        return instance;
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, BeanManager beanManager) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false, (boolean)false, (Bus)this.bus);
        ClassifiedClasses classified = this.classes2singletons(application, beanManager);
        instance.setProviders(classified.getProviders());
        instance.getFeatures().addAll(classified.getFeatures());
        for (ResourceProvider resourceProvider : classified.getResourceProviders()) {
            instance.setResourceProvider(resourceProvider.getResourceClass(), resourceProvider);
        }
        return instance;
    }

    private ClassifiedClasses classes2singletons(Application application, BeanManager beanManager) {
        ClassifiedClasses classified = new ClassifiedClasses();
        Set classes = application.getClasses();
        if (!classes.isEmpty()) {
            classified.addProviders(this.loadProviders(beanManager, classes));
            classified.addFeatures(this.loadFeatures(beanManager, classes));
            for (Bean<?> bean : this.serviceBeans) {
                Object resourceProvider;
                if (!classes.contains(bean.getBeanClass())) continue;
                if (this.isCxfSingleton(beanManager, bean)) {
                    Lifecycle lifecycle = new Lifecycle(beanManager, bean);
                    resourceProvider = new SingletonResourceProvider(lifecycle, bean.getBeanClass());
                    if (Dependent.class == bean.getScope()) {
                        this.disposableLifecycles.add(lifecycle);
                    }
                } else {
                    resourceProvider = new PerRequestResourceProvider(() -> new Lifecycle(beanManager, bean), bean.getBeanClass());
                }
                classified.addResourceProvider((ResourceProvider)resourceProvider);
            }
        }
        return classified;
    }

    boolean isCxfSingleton(BeanManager beanManager, Bean<?> bean) {
        return beanManager.isNormalScope(bean.getScope()) || this.isConsideredSingleton(bean.getScope());
    }

    private boolean isConsideredSingleton(Class<?> scope) {
        return Singleton.class == scope || Dependent.class == scope;
    }

    private List<Object> loadExternalProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        ServiceLoader<MessageBodyWriter> writers = ServiceLoader.load(MessageBodyWriter.class);
        for (MessageBodyWriter writer : writers) {
            providers.add(writer);
        }
        ServiceLoader<MessageBodyReader> readers = ServiceLoader.load(MessageBodyReader.class);
        for (MessageBodyReader reader : readers) {
            providers.add(reader);
        }
        return providers;
    }

    private List<Object> loadProviders(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.providerBeans);
    }

    private List<Object> loadServices(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.serviceBeans);
    }

    private List<Object> loadBeans(BeanManager beanManager, Collection<Class<?>> limitedClasses, Collection<Bean<?>> beans) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Bean<?> bean : beans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            instances.add(beanManager.getReference(bean, Object.class, this.createCreationalContext(beanManager, bean)));
        }
        return instances;
    }

    private List<Feature> loadFeatures(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        for (Bean<? extends Feature> bean : this.featureBeans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            features.add((Feature)beanManager.getReference(bean, Feature.class, this.createCreationalContext(beanManager, bean)));
        }
        return new ArrayList<Feature>(features);
    }

    private void customize(BeanManager beanManager, JAXRSServerFactoryBean bean) {
        JAXRSServerFactoryCustomizationUtils.customize((JAXRSServerFactoryBean)bean);
        Set extensionBeans = beanManager.getBeans(JAXRSServerFactoryCustomizationExtension.class, new Annotation[0]);
        for (Bean extensionBean : extensionBeans) {
            JAXRSServerFactoryCustomizationExtension extension = (JAXRSServerFactoryCustomizationExtension)beanManager.getReference(extensionBean, JAXRSServerFactoryCustomizationExtension.class, this.createCreationalContext(beanManager, extensionBean));
            extension.customize(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CreationalContext<T> createCreationalContext(BeanManager beanManager, Bean<T> bean) {
        CreationalContext creationalContext = beanManager.createCreationalContext(bean);
        if (!(bean instanceof DefaultApplicationBean)) {
            List<CreationalContext<?>> list = this.disposableCreationalContexts;
            synchronized (list) {
                this.disposableCreationalContexts.add(creationalContext);
            }
        }
        return creationalContext;
    }

    private <T> void processProducer(ProcessBean<T> event, Type baseType) {
        if (baseType instanceof Class) {
            Class clazz = (Class)baseType;
            if (clazz.isAnnotationPresent(Path.class)) {
                this.serviceBeans.add(event.getBean());
            } else if (clazz.isAnnotationPresent(Provider.class)) {
                this.providerBeans.add(event.getBean());
            } else if (clazz.isAnnotationPresent(ApplicationPath.class)) {
                this.applicationBeans.add(event.getBean());
            }
        }
    }

    public static Set<Class<?>> getCustomContextClasses() {
        ServiceLoader<ContextClassProvider> classProviders = ServiceLoader.load(ContextClassProvider.class);
        LinkedHashSet<Class> customContextClasses = new LinkedHashSet<Class>();
        for (ContextClassProvider classProvider : classProviders) {
            customContextClasses.add(classProvider.getContextClass());
        }
        return Collections.unmodifiableSet(customContextClasses);
    }

    private static boolean isAnnotationPresent(BeanManager beanManager, Annotated annotated, Class<? extends Annotation> annotationType) {
        if (annotated.isAnnotationPresent(annotationType)) {
            return true;
        }
        Stream<AnnotatedType> annotatedTypes = annotated.getTypeClosure().stream().filter(Class.class::isInstance).map(Class.class::cast).map(cls -> beanManager.createAnnotatedType(cls));
        return annotatedTypes.anyMatch(at -> at.isAnnotationPresent(annotationType));
    }

    private static final class ClassifiedClasses {
        private List<Object> providers = new ArrayList<Object>();
        private List<Feature> features = new ArrayList<Feature>();
        private List<ResourceProvider> resourceProviders = new ArrayList<ResourceProvider>();

        private ClassifiedClasses() {
        }

        public void addProviders(Collection<Object> others) {
            this.providers.addAll(others);
        }

        public void addFeatures(Collection<Feature> others) {
            this.features.addAll(others);
        }

        public void addResourceProvider(ResourceProvider other) {
            this.resourceProviders.add(other);
        }

        public List<Object> getProviders() {
            return this.providers;
        }

        public List<Feature> getFeatures() {
            return this.features;
        }

        public List<ResourceProvider> getResourceProviders() {
            return this.resourceProviders;
        }
    }
}

