/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.cdi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessBean;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.cdi.CdiBusBean;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class JAXRSCdiResourceExtension
implements Extension {
    private Bean<?> busBean;
    private Bus bus;
    private final List<Bean<?>> applicationBeans = new ArrayList();
    private final List<Bean<?>> serviceBeans = new ArrayList();
    private final List<Bean<?>> providerBeans = new ArrayList();
    private final List<Bean<? extends Feature>> featureBeans = new ArrayList<Bean<? extends Feature>>();

    public <T> void collect(@Observes ProcessBean<T> event) {
        if (event.getAnnotated().isAnnotationPresent(ApplicationPath.class)) {
            this.applicationBeans.add(event.getBean());
        } else if (event.getAnnotated().isAnnotationPresent(Path.class)) {
            this.serviceBeans.add(event.getBean());
        } else if (event.getAnnotated().isAnnotationPresent(Provider.class)) {
            this.providerBeans.add(event.getBean());
        } else if (event.getBean().getTypes().contains(Feature.class)) {
            this.featureBeans.add((Bean<? extends Feature>)event.getBean());
        } else if ("cxf".equals(event.getBean().getName()) && Bus.class.isAssignableFrom(event.getBean().getBeanClass())) {
            this.busBean = event.getBean();
        }
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        this.bus = (Bus)beanManager.getReference(this.busBean, (Type)this.busBean.getBeanClass(), beanManager.createCreationalContext(this.busBean));
        for (Bean<?> application : this.applicationBeans) {
            JAXRSServerFactoryBean factory;
            Application instance = (Application)beanManager.getReference(application, (Type)application.getBeanClass(), beanManager.createCreationalContext(application));
            if (instance.getSingletons().isEmpty() && instance.getClasses().isEmpty()) {
                factory = this.createFactoryInstance(instance, this.loadServices(beanManager, Collections.emptySet()), this.loadProviders(beanManager, Collections.emptySet()), this.loadFeatures(beanManager, Collections.emptySet()));
                factory.init();
                continue;
            }
            factory = this.createFactoryInstance(instance, beanManager);
            factory.init();
        }
    }

    public void injectBus(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.busBean == null) {
            AnnotatedType busAnnotatedType = beanManager.createAnnotatedType(ExtensionManagerBus.class);
            InjectionTarget busInjectionTarget = beanManager.createInjectionTarget(busAnnotatedType);
            this.busBean = new CdiBusBean((InjectionTarget<ExtensionManagerBus>)busInjectionTarget);
            event.addBean(this.busBean);
        }
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, List<?> services, List<?> providers, List<? extends Feature> features) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false);
        instance.setServiceBeans(new ArrayList(services));
        instance.setProviders(providers);
        instance.setProviders(this.loadExternalProviders());
        instance.setFeatures(features);
        instance.setBus(this.bus);
        return instance;
    }

    private JAXRSServerFactoryBean createFactoryInstance(Application application, BeanManager beanManager) {
        JAXRSServerFactoryBean instance = ResourceUtils.createApplication((Application)application, (boolean)false, (boolean)false);
        Map<Class<?>, List<Object>> classified = this.classifySingletons(application, beanManager);
        instance.setServiceBeans(classified.get(Path.class));
        instance.setProviders(classified.get(Provider.class));
        instance.setFeatures(CastUtils.cast(classified.get(Feature.class), Feature.class));
        instance.setBus(this.bus);
        return instance;
    }

    private Map<Class<?>, List<Object>> classifySingletons(Application application, BeanManager beanManager) {
        Set singletons = application.getSingletons();
        HashMap classified = new HashMap();
        classified.put(Feature.class, new ArrayList());
        classified.put(Provider.class, new ArrayList());
        classified.put(Path.class, new ArrayList());
        for (Object singleton : singletons) {
            if (singleton instanceof Feature) {
                ((List)classified.get(Feature.class)).add(singleton);
                continue;
            }
            if (singleton.getClass().isAnnotationPresent(Provider.class)) {
                ((List)classified.get(Provider.class)).add(singleton);
                continue;
            }
            if (!singleton.getClass().isAnnotationPresent(Path.class)) continue;
            ((List)classified.get(Path.class)).add(singleton);
        }
        Set classes = application.getClasses();
        if (!classes.isEmpty()) {
            ((List)classified.get(Path.class)).addAll(this.loadServices(beanManager, classes));
            ((List)classified.get(Provider.class)).addAll(this.loadProviders(beanManager, classes));
            ((List)classified.get(Feature.class)).addAll(this.loadFeatures(beanManager, classes));
        }
        return classified;
    }

    private List<Object> loadExternalProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        ServiceLoader<MessageBodyWriter> writers = ServiceLoader.load(MessageBodyWriter.class);
        for (MessageBodyWriter writer : writers) {
            providers.add(writer);
        }
        ServiceLoader<MessageBodyReader> readers = ServiceLoader.load(MessageBodyReader.class);
        for (MessageBodyReader reader : readers) {
            providers.add(reader);
        }
        return providers;
    }

    private List<Object> loadProviders(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.providerBeans);
    }

    private List<Object> loadServices(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        return this.loadBeans(beanManager, limitedClasses, this.serviceBeans);
    }

    private List<Object> loadBeans(BeanManager beanManager, Collection<Class<?>> limitedClasses, Collection<Bean<?>> beans) {
        ArrayList<Object> instances = new ArrayList<Object>();
        for (Bean<?> bean : beans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            instances.add(beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean)));
        }
        return instances;
    }

    private List<Feature> loadFeatures(BeanManager beanManager, Collection<Class<?>> limitedClasses) {
        ArrayList<Feature> services = new ArrayList<Feature>();
        for (Bean<? extends Feature> bean : this.featureBeans) {
            if (!limitedClasses.isEmpty() && !limitedClasses.contains(bean.getBeanClass())) continue;
            services.add((Feature)beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean)));
        }
        return services;
    }
}

