/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.apache.cxf.configuration.spring.ConfigurerImpl;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class BusWiringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(BusWiringBeanFactoryPostProcessor.class);
    Bus bus;

    public BusWiringBeanFactoryPostProcessor() {
    }

    public BusWiringBeanFactoryPostProcessor(Bus b) {
        this.bus = b;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        Bus inject = this.bus;
        if (factory.containsBeanDefinition("cxf")) {
            inject = new RuntimeBeanReference("cxf");
        }
        for (String beanName : factory.getBeanDefinitionNames()) {
            LOG.fine("Checking bean " + beanName);
            BeanDefinition beanDefinition = factory.getBeanDefinition(beanName);
            if (BusWiringType.PROPERTY == beanDefinition.getAttribute(AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE)) {
                LOG.fine("Found " + AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE + " attribute " + (Object)((Object)BusWiringType.PROPERTY) + " on bean " + beanName);
                beanDefinition.getPropertyValues().addPropertyValue("bus", (Object)inject);
                continue;
            }
            if (BusWiringType.CONSTRUCTOR != beanDefinition.getAttribute(AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE)) continue;
            LOG.fine("Found " + AbstractBeanDefinitionParser.WIRE_BUS_ATTRIBUTE + " attribute " + (Object)((Object)BusWiringType.CONSTRUCTOR) + " on bean " + beanName);
            ConstructorArgumentValues constructorArgs = beanDefinition.getConstructorArgumentValues();
            this.insertConstructorArg(constructorArgs, inject);
        }
    }

    private void insertConstructorArg(ConstructorArgumentValues constructorArgs, Object valueToInsert) {
        ArrayList genericArgs = new ArrayList(CastUtils.cast(constructorArgs.getGenericArgumentValues()));
        HashMap indexedArgs = new HashMap(CastUtils.cast(constructorArgs.getIndexedArgumentValues()));
        constructorArgs.clear();
        for (ConstructorArgumentValues.ValueHolder valueHolder : genericArgs) {
            constructorArgs.addGenericArgumentValue(valueHolder);
        }
        for (Map.Entry entry : indexedArgs.entrySet()) {
            constructorArgs.addIndexedArgumentValue((Integer)entry.getKey() + 1, (ConstructorArgumentValues.ValueHolder)entry.getValue());
        }
        constructorArgs.addIndexedArgumentValue(0, valueToInsert);
    }

    public static void updateBusReferencesInContext(Bus bus, ApplicationContext ctx) {
        Configurer conf = bus.getExtension(Configurer.class);
        if (conf instanceof ConfigurerImpl) {
            ((ConfigurerImpl)conf).addApplicationContext(ctx);
        }
        if (ctx instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cctx = (ConfigurableApplicationContext)ctx;
            new BusWiringBeanFactoryPostProcessor(bus).postProcessBeanFactory(cctx.getBeanFactory());
        }
    }
}

