/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.builder.primitive;

import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class PrimitiveAssertion
implements PolicyAssertion {
    protected QName name;
    protected boolean optional;

    public PrimitiveAssertion() {
        this((QName)null);
    }

    public PrimitiveAssertion(QName n) {
        this(n, false);
    }

    public PrimitiveAssertion(QName n, boolean o) {
        this.name = n;
        this.optional = o;
    }

    public PrimitiveAssertion(Element element) {
        this.name = new QName(element.getNamespaceURI(), element.getLocalName());
        NamedNodeMap atts = element.getAttributes();
        if (atts != null) {
            for (int x = 0; x < atts.getLength(); ++x) {
                Attr att = (Attr)atts.item(x);
                QName qn = new QName(att.getNamespaceURI(), att.getLocalName());
                if (!PolicyConstants.isOptionalAttribute(qn)) continue;
                this.optional = Boolean.valueOf(att.getValue());
            }
        }
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equal(PolicyComponent policyComponent) {
        if (policyComponent.getType() != 5) {
            return false;
        }
        return this.getName().equals(((PolicyAssertion)policyComponent).getName());
    }

    public short getType() {
        return 5;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean o) {
        this.optional = o;
    }

    public PolicyComponent normalize() {
        if (this.isOptional()) {
            Policy policy = new Policy();
            ExactlyOne exactlyOne = new ExactlyOne();
            All all = new All();
            all.addPolicyComponent((PolicyComponent)this.cloneMandatory());
            exactlyOne.addPolicyComponent((PolicyComponent)all);
            exactlyOne.addPolicyComponent((PolicyComponent)new All());
            policy.addPolicyComponent((PolicyComponent)exactlyOne);
            return policy;
        }
        return this.cloneMandatory();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
    }

    protected PolicyAssertion cloneMandatory() {
        return new PrimitiveAssertion(this.name, false);
    }

    public Policy getPolicy() {
        return null;
    }

    public boolean isAsserted(AssertionInfoMap aim) {
        Collection<AssertionInfo> ail = aim.getAssertionInfo(this.name);
        for (AssertionInfo ai : ail) {
            if (!ai.isAsserted() || !ai.getAssertion().equal((PolicyComponent)this)) continue;
            return true;
        }
        return false;
    }
}

