/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types.orc;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.crunch.MapFn;
import org.apache.crunch.Tuple;
import org.apache.crunch.TupleN;
import org.apache.crunch.fn.CompositeMapFn;
import org.apache.crunch.io.orc.OrcWritable;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.TupleFactory;
import org.apache.crunch.types.orc.OrcUtils;
import org.apache.crunch.types.orc.TupleObjectInspector;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class Orcs {
    private static Map<Class<?>, Field[]> fieldsCache = new HashMap();

    public static final PType<OrcStruct> orcs(TypeInfo typeInfo) {
        return Writables.derived(OrcStruct.class, (MapFn)new OrcInFn(typeInfo), (MapFn)new OrcOutFn(typeInfo), (PType)Writables.writables(OrcWritable.class));
    }

    public static final <T> PType<T> reflects(Class<T> clazz) {
        TypeInfo reflectInfo = Orcs.createReflectTypeInfo(clazz);
        return Writables.derived(clazz, new ReflectInFn<T>(clazz), new ReflectOutFn<T>(clazz), Orcs.orcs(reflectInfo));
    }

    private static TypeInfo createReflectTypeInfo(Class<?> clazz) {
        ObjectInspector reflectOi = ObjectInspectorFactory.getReflectionObjectInspector(clazz, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)reflectOi);
    }

    public static final PType<TupleN> tuples(PType ... ptypes) {
        TypeInfo tupleInfo = Orcs.createTupleTypeInfo(ptypes);
        return Orcs.derived(TupleN.class, new TupleInFn(TupleFactory.TUPLEN, ptypes), new TupleOutFn(ptypes), Orcs.orcs(tupleInfo), ptypes);
    }

    static <S, T> PType<T> derived(Class<T> clazz, MapFn<S, T> inputFn, MapFn<T, S> outputFn, PType<S> base, PType[] subTypes) {
        WritableType wt = (WritableType)base;
        CompositeMapFn input = new CompositeMapFn(wt.getInputMapFn(), inputFn);
        CompositeMapFn output = new CompositeMapFn(outputFn, wt.getOutputMapFn());
        return new WritableType(clazz, wt.getSerializationClass(), (MapFn)input, (MapFn)output, subTypes);
    }

    private static TypeInfo createTupleTypeInfo(PType ... ptypes) {
        TupleObjectInspector tupleOi = new TupleObjectInspector(null, ptypes);
        return TypeInfoUtils.getTypeInfoFromObjectInspector(tupleOi);
    }

    private static class TupleOutFn<T extends Tuple>
    extends MapFn<T, OrcStruct> {
        private PType[] ptypes;
        private transient ObjectInspector tupleOi;
        private transient ObjectInspector orcOi;

        public TupleOutFn(PType ... ptypes) {
            this.ptypes = ptypes;
        }

        public void initialize() {
            this.tupleOi = new TupleObjectInspector(null, this.ptypes);
            TypeInfo info = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.tupleOi);
            this.orcOi = OrcStruct.createObjectInspector((TypeInfo)info);
        }

        public OrcStruct map(T input) {
            return (OrcStruct)OrcUtils.convert(input, this.tupleOi, this.orcOi);
        }
    }

    private static class TupleInFn<T extends Tuple>
    extends MapFn<OrcStruct, T> {
        private PType[] ptypes;
        private TupleFactory<T> tupleFactory;
        private transient ObjectInspector tupleOi;
        private transient ObjectInspector orcOi;

        public TupleInFn(TupleFactory<T> tupleFactory, PType ... ptypes) {
            this.tupleFactory = tupleFactory;
            this.ptypes = ptypes;
        }

        public void initialize() {
            this.tupleOi = new TupleObjectInspector<T>(this.tupleFactory, this.ptypes);
            TypeInfo info = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.tupleOi);
            this.orcOi = OrcStruct.createObjectInspector((TypeInfo)info);
        }

        public T map(OrcStruct input) {
            return (T)((Tuple)OrcUtils.convert(input, this.orcOi, this.tupleOi));
        }
    }

    private static class ReflectOutFn<T>
    extends MapFn<T, OrcStruct> {
        private Class<T> typeClass;
        private TypeInfo typeInfo;
        private transient ObjectInspector reflectOi;
        private transient SettableStructObjectInspector orcOi;

        public void initialize() {
            this.reflectOi = ObjectInspectorFactory.getReflectionObjectInspector(this.typeClass, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            this.orcOi = (SettableStructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
        }

        public ReflectOutFn(Class<T> typeClass) {
            this.typeClass = typeClass;
            this.typeInfo = Orcs.createReflectTypeInfo(typeClass);
        }

        public OrcStruct map(T input) {
            return (OrcStruct)OrcUtils.convert(input, this.reflectOi, (ObjectInspector)this.orcOi);
        }
    }

    private static class ReflectInFn<T>
    extends MapFn<OrcStruct, T> {
        private Class<T> typeClass;
        private TypeInfo typeInfo;
        private transient ObjectInspector reflectOi;
        private transient ObjectInspector orcOi;

        public void initialize() {
            this.reflectOi = ObjectInspectorFactory.getReflectionObjectInspector(this.typeClass, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            this.orcOi = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
        }

        public ReflectInFn(Class<T> typeClass) {
            this.typeClass = typeClass;
            this.typeInfo = Orcs.createReflectTypeInfo(typeClass);
        }

        public T map(OrcStruct input) {
            return (T)OrcUtils.convert(input, this.orcOi, this.reflectOi);
        }
    }

    private static class OrcOutFn
    extends MapFn<OrcStruct, OrcWritable> {
        private TypeInfo typeInfo;
        private transient ObjectInspector oi;
        private transient BinarySortableSerDe serde;

        public OrcOutFn(TypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        public void initialize() {
            this.oi = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
            this.serde = OrcUtils.createBinarySerde(this.typeInfo);
        }

        public OrcWritable map(OrcStruct input) {
            OrcWritable output = new OrcWritable();
            output.setObjectInspector(this.oi);
            output.setSerde(this.serde);
            output.set(input);
            return output;
        }
    }

    private static class OrcInFn
    extends MapFn<OrcWritable, OrcStruct> {
        private TypeInfo typeInfo;
        private transient ObjectInspector oi;
        private transient BinarySortableSerDe serde;

        public OrcInFn(TypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        public void initialize() {
            this.oi = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
            this.serde = OrcUtils.createBinarySerde(this.typeInfo);
        }

        public OrcStruct map(OrcWritable input) {
            input.setObjectInspector(this.oi);
            input.setSerde(this.serde);
            return input.get();
        }
    }
}

