/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.orc;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.orc.OrcCrunchInputFormat;
import org.apache.crunch.io.orc.OrcFileReaderFactory;
import org.apache.crunch.io.orc.OrcReadableData;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class OrcFileSource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private int[] readColumns;
    public static final String HIVE_READ_ALL_COLUMNS = "hive.io.file.read.all.columns";

    private static <S> FormatBundle<OrcCrunchInputFormat> getBundle(int[] readColumns) {
        FormatBundle fb = FormatBundle.forInput(OrcCrunchInputFormat.class);
        if (readColumns != null) {
            fb.set(HIVE_READ_ALL_COLUMNS, "false");
            fb.set("hive.io.file.readcolumn.ids", OrcFileSource.getColumnIdsStr(readColumns));
        }
        return fb;
    }

    static String getColumnIdsStr(int[] columns) {
        StringBuilder sb = new StringBuilder();
        for (int c : columns) {
            sb.append(c);
            sb.append(',');
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public OrcFileSource(Path path, PType<T> ptype) {
        this(path, ptype, null);
    }

    public OrcFileSource(Path path, PType<T> ptype, int[] readColumns) {
        super(path, ptype, OrcFileSource.getBundle(readColumns));
        this.readColumns = readColumns;
    }

    public OrcFileSource(List<Path> paths, PType<T> ptype) {
        this(paths, ptype, null);
    }

    public OrcFileSource(List<Path> paths, PType<T> ptype, int[] columns) {
        super(paths, ptype, OrcFileSource.getBundle(columns));
    }

    public String toString() {
        return "Orc(" + this.pathsAsString() + ")";
    }

    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, new OrcFileReaderFactory(this.ptype, this.readColumns));
    }

    public ReadableData<T> asReadable() {
        return new OrcReadableData(this.paths, this.ptype, this.readColumns);
    }
}

