/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rdf.simple;

import java.util.Objects;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

final class TripleImpl
implements Triple {
    private final BlankNodeOrIRI subject;
    private final IRI predicate;
    private final RDFTerm object;

    public TripleImpl(BlankNodeOrIRI subject, IRI predicate, RDFTerm object) {
        this.subject = Objects.requireNonNull(subject);
        this.predicate = Objects.requireNonNull(predicate);
        this.object = Objects.requireNonNull(object);
    }

    public BlankNodeOrIRI getSubject() {
        return this.subject;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public RDFTerm getObject() {
        return this.object;
    }

    public String toString() {
        return this.getSubject().ntriplesString() + " " + this.getPredicate().ntriplesString() + " " + this.getObject().ntriplesString() + " .";
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.predicate, this.object);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)obj;
        return this.getSubject().equals(other.getSubject()) && this.getPredicate().equals((Object)other.getPredicate()) && this.getObject().equals((Object)other.getObject());
    }
}

