/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive.rank;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.stat.descriptive.AbstractStorelessUnivariateStatistic;

public class Min
extends AbstractStorelessUnivariateStatistic {
    private long n;
    private double value;

    public Min() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Min(Min original) throws NullArgumentException {
        Min.copy(original, this);
    }

    @Override
    public void increment(double d) {
        if (d < this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    @Override
    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double min = Double.NaN;
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length)) {
            min = values[begin];
            for (int i = begin; i < begin + length; ++i) {
                if (Double.isNaN(values[i])) continue;
                min = min < values[i] ? min : values[i];
            }
        }
        return min;
    }

    @Override
    public Min copy() {
        Min result = new Min();
        Min.copy(this, result);
        return result;
    }

    public static void copy(Min source, Min dest) throws NullArgumentException {
        NullArgumentException.check((Object)source);
        NullArgumentException.check((Object)dest);
        dest.n = source.n;
        dest.value = source.value;
    }
}

