/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.spring.configurator.ResourceFilter;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.apache.cocoon.spring.configurator.impl.RunningModeHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class ExtendedPropertyOverrideConfigurer
extends PropertyOverrideConfigurer {
    protected List locations;
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();
    protected ResourceFilter resourceFilter;
    protected Settings settings;

    public ExtendedPropertyOverrideConfigurer() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("classpath*:META-INF/cocoon/spring");
        list.add("/WEB-INF/cocoon/spring");
    }

    public void setLocations(List list) {
        this.locations = list;
    }

    public void setSettings(Settings object) {
        this.settings = object;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing bean factory: " + beanFactory));
        }
        String mode = RunningModeHelper.determineRunningMode(this.settings != null ? this.settings.getRunningMode() : null);
        Properties mergedProps = new Properties();
        if (this.locations != null) {
            Iterator i = this.locations.iterator();
            while (i.hasNext()) {
                String location = (String)i.next();
                ResourceUtils.readProperties(location, mergedProps, this.resourceLoader, this.resourceFilter, this.logger);
                ResourceUtils.readProperties(location + '/' + mode, mergedProps, this.resourceLoader, this.resourceFilter, this.logger);
            }
        }
        if (mergedProps.size() > 0) {
            this.convertProperties(mergedProps);
            this.processProperties(beanFactory, mergedProps);
        }
    }
}

