/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;

public class BeanMap
implements Map,
BeanFactoryAware {
    protected final Map beanMap = new HashMap();
    protected boolean initialized = false;
    protected ListableBeanFactory beanFactory;
    protected Class beanClass;
    protected boolean stripPrefix = true;
    protected boolean checkParent = true;
    protected List hasProperties = new ArrayList();
    protected String keyProperty;

    protected void load(Set beanNames) {
        String prefix1 = this.beanClass.getName() + '.';
        String prefix2 = this.beanClass.getName() + '/';
        Iterator i = beanNames.iterator();
        while (i.hasNext()) {
            BeanWrapperImpl wrapper;
            Object bean;
            String beanName = (String)i.next();
            Object key = beanName;
            if (this.stripPrefix && (beanName.startsWith(prefix1) || beanName.startsWith(prefix2))) {
                key = beanName.substring(prefix1.length());
            }
            if (this.hasProperties.size() > 0) {
                bean = this.beanFactory.getBean(beanName);
                wrapper = new BeanWrapperImpl(bean);
                boolean isOk = true;
                Iterator iter = this.hasProperties.iterator();
                while (iter.hasNext()) {
                    String propName = (String)iter.next();
                    if (wrapper.isReadableProperty(propName)) continue;
                    isOk = false;
                }
                if (!isOk) continue;
                if (this.keyProperty != null && this.keyProperty.length() > 0 && wrapper.isReadableProperty(this.keyProperty)) {
                    key = wrapper.getPropertyValue(this.keyProperty);
                }
                this.beanMap.put(key, bean);
                continue;
            }
            bean = this.beanFactory.getBean(beanName);
            wrapper = new BeanWrapperImpl(bean);
            if (this.keyProperty != null && this.keyProperty.length() > 0 && wrapper.isReadableProperty(this.keyProperty)) {
                key = wrapper.getPropertyValue(this.keyProperty);
            }
            this.beanMap.put(key, bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInit() {
        if (!this.initialized) {
            BeanMap beanMap = this;
            synchronized (beanMap) {
                if (!this.initialized) {
                    if (this.beanFactory != null) {
                        HashSet beanNames = new HashSet();
                        this.getBeanNames(this.beanFactory, beanNames);
                        this.load(beanNames);
                    }
                    this.initialized = true;
                }
            }
        }
    }

    protected void getBeanNames(ListableBeanFactory factory, Set beanNames) {
        if (this.checkParent && factory instanceof HierarchicalBeanFactory && ((HierarchicalBeanFactory)factory).getParentBeanFactory() != null) {
            this.getBeanNames((ListableBeanFactory)((HierarchicalBeanFactory)factory).getParentBeanFactory(), beanNames);
        }
        String[] names = factory.getBeanNamesForType(this.beanClass);
        for (int i = 0; i < names.length; ++i) {
            beanNames.add(names[i]);
        }
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        if (!(factory instanceof ListableBeanFactory)) {
            throw new BeanDefinitionStoreException("BeanFactory must be listable.");
        }
        this.beanFactory = (ListableBeanFactory)factory;
    }

    public void setStripPrefix(boolean stripPrefix) {
        this.stripPrefix = stripPrefix;
    }

    public void setCheckParent(boolean checkParent) {
        this.checkParent = checkParent;
    }

    public void setHasProperties(String pHasProperties) {
        StringTokenizer tokenizer = new StringTokenizer(pHasProperties, " \t\n\r\f,");
        ArrayList<String> propNames = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            propNames.add(tokenizer.nextToken());
        }
        this.hasProperties = propNames;
    }

    public void setKeyProperty(String pKeyProperty) {
        this.keyProperty = pKeyProperty;
    }

    public void setType(Class typeClass) {
        this.beanClass = typeClass;
    }

    public void clear() {
        this.initialized = true;
        this.beanMap.clear();
    }

    public boolean containsKey(Object key) {
        this.checkInit();
        return this.beanMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        this.checkInit();
        return this.beanMap.containsValue(value);
    }

    public Set entrySet() {
        this.checkInit();
        return this.beanMap.entrySet();
    }

    public Object get(Object key) {
        this.checkInit();
        return this.beanMap.get(key);
    }

    public boolean isEmpty() {
        this.checkInit();
        return this.beanMap.isEmpty();
    }

    public Set keySet() {
        this.checkInit();
        return this.beanMap.keySet();
    }

    public Object put(Object key, Object value) {
        this.checkInit();
        return this.beanMap.put(key, value);
    }

    public void putAll(Map t) {
        this.checkInit();
        this.beanMap.putAll(t);
    }

    public Object remove(Object key) {
        this.checkInit();
        return this.beanMap.remove(key);
    }

    public int size() {
        this.checkInit();
        return this.beanMap.size();
    }

    public Collection values() {
        this.checkInit();
        return this.beanMap.values();
    }

    public boolean equals(Object obj) {
        this.checkInit();
        return ((Object)this.beanMap).equals(obj);
    }

    public int hashCode() {
        this.checkInit();
        return ((Object)this.beanMap).hashCode();
    }

    public String toString() {
        this.checkInit();
        return this.beanMap.toString();
    }
}

