/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.shielding;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.cocoon.classloader.ClassLoaderConfiguration;
import org.apache.cocoon.classloader.ClassLoaderFactory;
import org.apache.cocoon.classloader.DefaultClassLoaderFactory;

public class ShieldedGroupClassLoaderManager {
    public static final String SHIELDED_GROUP_PARAM = "shielded-group";
    public static final String SHIELDED_LIB_PARAM = "shielded-lib";
    public static final String SHIELDED_CLASSES_PARAM = "shielded-classes";
    public static final String CLASSLOADER_FACTORY_PARAM = "classloader-factory";
    protected static final String SHIELDED_LIB = "shielded/lib";
    protected static final String SHIELDED_CLASSES = "shielded/classes";
    protected static Map groupClassloaders = new HashMap();

    public static synchronized ClassLoader getClassLoader(ServletContext servletContext, Map parameters) throws ServletException {
        String classLoaderGroup = (String)parameters.get(SHIELDED_GROUP_PARAM);
        if (classLoaderGroup != null && groupClassloaders.containsKey(classLoaderGroup)) {
            return (ClassLoader)groupClassloaders.get(classLoaderGroup);
        }
        ClassLoader shieldedClassLoader = ShieldedGroupClassLoaderManager.createClassLoader(ShieldedGroupClassLoaderManager.class.getClassLoader(), servletContext, parameters);
        if (classLoaderGroup != null) {
            groupClassloaders.put(classLoaderGroup, shieldedClassLoader);
        }
        return shieldedClassLoader;
    }

    protected static ClassLoader createClassLoader(ClassLoader parent, ServletContext servletContext, Map parameters) throws ServletException {
        String classesDirectory = SHIELDED_CLASSES;
        String jarDirectory = SHIELDED_LIB;
        if (parameters.get(SHIELDED_CLASSES_PARAM) != null) {
            classesDirectory = (String)parameters.get(SHIELDED_CLASSES_PARAM);
        }
        if (parameters.get(SHIELDED_LIB_PARAM) != null) {
            jarDirectory = (String)parameters.get(SHIELDED_LIB_PARAM);
        }
        ClassLoaderConfiguration config = new ClassLoaderConfiguration();
        config.addClassDirectory(classesDirectory);
        config.addLibDirectory(jarDirectory);
        String factoryClassName = DefaultClassLoaderFactory.class.getName();
        if (parameters.get(CLASSLOADER_FACTORY_PARAM) != null) {
            factoryClassName = (String)parameters.get(CLASSLOADER_FACTORY_PARAM);
        }
        try {
            Class<?> classLoaderFactoryClass = Class.forName(factoryClassName);
            ClassLoaderFactory factory = (ClassLoaderFactory)classLoaderFactoryClass.newInstance();
            return factory.createClassLoader(config.getClass().getClassLoader(), config, servletContext);
        }
        catch (InstantiationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

