/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.postable.components;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.serialization.AbstractSerializer;
import org.apache.cocoon.servletservice.postable.PostableSource;
import org.apache.cocoon.sitemap.SitemapModelComponent;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.SAXException;

public class ServletServiceSerializer
extends AbstractSerializer
implements SitemapModelComponent {
    private PostableSource servletSource;
    private Response response;
    private SaxBuffer saxBuffer;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        String service;
        try {
            service = par.getParameter("service");
        }
        catch (ParameterException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
        try {
            this.servletSource = (PostableSource)resolver.resolveURI(service);
        }
        catch (ClassCastException e) {
            throw new ProcessingException("Resolved '" + service + "' to source that is not postable. Use servlet: protocol for service calls.");
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + service + "'."), (SourceException)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Source " + service + " resolved to " + this.servletSource.getURI()));
        }
        this.saxBuffer = new SaxBuffer();
        this.setConsumer((XMLConsumer)this.saxBuffer);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
    }

    public void endDocument() throws SAXException {
        String serializedXML;
        super.endDocument();
        try {
            serializedXML = XMLUtils.serialize((XMLizable)this.saxBuffer, (Properties)XMLUtils.createPropertiesForXML((boolean)false));
        }
        catch (ProcessingException e) {
            throw new SAXException("Exception occured while serializing content of sax buffer", (Exception)((Object)e));
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter(this.servletSource.getOutputStream(), "UTF-8");
            IOUtils.copy((Reader)new StringReader(serializedXML), (Writer)out);
            ((Writer)out).flush();
        }
        catch (IOException e) {
            throw new SAXException("Exception occured while writing to the output stream of source '" + this.servletSource.getURI() + "'", e);
        }
        try {
            this.response.setHeader("Content-Type", this.servletSource.getMimeType());
            IOUtils.copy((InputStream)this.servletSource.getInputStream(), (OutputStream)this.output);
        }
        catch (Exception e) {
            throw new SAXException("Exception occured while copying response from the service to the output stream", e);
        }
    }
}

