/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cocoon.tools.rcl.wrapper.servlet.CocoonReloadingListener;
import org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingClassloaderManager;

public class ReloadingServletFilter
implements Filter {
    protected Filter filter;
    protected ServletContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filter != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.context));
                CocoonReloadingListener.enableConsoleOutput();
                this.filter.doFilter(request, response, chain);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        String filterName = config.getInitParameter("filter-class");
        this.context = config.getServletContext();
        if (filterName == null) {
            throw new ServletException("ReloadingServletFilter: 'filter-class' parameter is missing.");
        }
        try {
            Class<?> filterClass = ReloadingClassloaderManager.getClassLoader(this.context).loadClass(filterName);
            this.filter = (Filter)filterClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load filter " + filterName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.context));
            this.filter.init(config);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.filter != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.context));
                this.filter.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

