/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.cocoon.tools.rcl.wrapper.servlet.CocoonReloadingListener;
import org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingClassloaderManager;

public class ReloadingServlet
extends HttpServlet {
    protected Servlet servlet;
    protected ServletConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        String servletName = config.getInitParameter("servlet-class");
        if (servletName == null) {
            throw new ServletException("ReloadingServlet: Init-Parameter 'servlet-class' is missing.");
        }
        try {
            ClassLoader cl = ReloadingClassloaderManager.getClassLoader(config.getServletContext());
            Class<?> servletClass = cl.loadClass(servletName);
            this.servlet = (Servlet)servletClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load servlet " + servletName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(config.getServletContext()));
            this.servlet.init(this.getServletConfig());
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.config.getServletContext()));
            CocoonReloadingListener.enableConsoleOutput();
            this.servlet.service(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.servlet != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ReloadingClassloaderManager.getClassLoader(this.config.getServletContext()));
                this.servlet.destroy();
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
        super.destroy();
    }
}

