/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.tools.rcl.wrapper.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.cocoon.tools.rcl.wrapper.servlet.CocoonReloadingListener;
import org.apache.cocoon.tools.rcl.wrapper.servlet.ReloadingClassloaderCreationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationMonitor;

public class ReloadingClassloaderManager {
    private static final String FILE_PROTOCOL = "file:";
    private static ClassLoader reloadingClassloader = null;

    private ReloadingClassloaderManager() {
    }

    public static synchronized ClassLoader getClassLoader(ServletContext context) {
        if (reloadingClassloader == null) {
            ClassLoader urlClassloader = ReloadingClassloaderManager.createURLClassLoader(context);
            if (ReloadingClassloaderManager.isReloadingClassloaderEnabled(context)) {
                ReloadingClassLoader classloader = new ReloadingClassLoader(urlClassloader);
                FilesystemAlterationMonitor fam = new FilesystemAlterationMonitor();
                List lines = null;
                try {
                    lines = IOUtils.readLines((InputStream)context.getResourceAsStream("/WEB-INF/cocoon/rclwrapper.rcl.conf"));
                }
                catch (IOException ioe) {
                    throw new ReloadingClassloaderCreationException("Error while creating the URLClassLoader from context://WEB-INF/cocoon/rclwrapper.rcl.conf", ioe);
                }
                Iterator linesIt = lines.iterator();
                while (linesIt.hasNext()) {
                    String line = (String)linesIt.next();
                    if (!line.startsWith(FILE_PROTOCOL)) {
                        throw new ReloadingClassloaderCreationException("Only support URLs with file: protocol.");
                    }
                    String url = line.substring(FILE_PROTOCOL.length());
                    if (url.indexOf(2) == 58) {
                        url = url.substring(1);
                    }
                    File directory = new File(url);
                    CocoonReloadingListener rl = new CocoonReloadingListener();
                    rl.addReloadNotificationListener((ReloadNotificationListener)classloader);
                    fam.addListener(directory, (FilesystemAlterationListener)rl);
                }
                fam.start();
                reloadingClassloader = classloader;
            } else {
                reloadingClassloader = urlClassloader;
            }
        }
        return reloadingClassloader;
    }

    protected static ClassLoader createURLClassLoader(ServletContext context) {
        try {
            ArrayList<URL> urlsList = new ArrayList<URL>();
            List lines = IOUtils.readLines((InputStream)context.getResourceAsStream("/WEB-INF/cocoon/rclwrapper.urlcl.conf"));
            Iterator linesIt = lines.iterator();
            while (linesIt.hasNext()) {
                String line = (String)linesIt.next();
                urlsList.add(new URL(line));
            }
            URL[] urls = urlsList.toArray(new URL[urlsList.size()]);
            return new URLClassLoader(urls, ReloadingClassloaderManager.class.getClassLoader());
        }
        catch (Exception e) {
            throw new ReloadingClassloaderCreationException("Error while creating the URLClassLoader from context://WEB-INF/cocoon/rclwrapper.urlcl.conf", e);
        }
    }

    protected static boolean isReloadingClassloaderEnabled(ServletContext servletContext) {
        Properties rclProps = new Properties();
        try {
            rclProps.load(servletContext.getResourceAsStream("/WEB-INF/cocoon/rclwrapper.properties"));
        }
        catch (IOException e) {
            throw new ReloadingClassloaderCreationException("Error while reading /WEB-INF/cocoon/rclwrapper.properties from servlet context.", e);
        }
        String reloadingEnabled = rclProps.getProperty("reloading.classloader.enabled", "true");
        return reloadingEnabled.trim().toLowerCase().equals("true");
    }
}

