/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.om;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.portal.om.CopletAdapter;
import org.apache.cocoon.portal.util.PortalUtils;

public final class CopletType {
    protected Map copletConfig = Collections.EMPTY_MAP;
    protected final String id;
    protected CopletAdapter copletAdapter;

    public CopletType(String id, CopletAdapter adapter) {
        String idErrorMsg = PortalUtils.testId(id);
        if (idErrorMsg != null) {
            throw new IllegalArgumentException(idErrorMsg);
        }
        this.id = id;
        this.copletAdapter = adapter;
    }

    public CopletType(String id) {
        this(id, null);
    }

    public String getId() {
        return this.id;
    }

    public CopletAdapter getCopletAdapter() {
        return this.copletAdapter;
    }

    public void setCopletAdapter(CopletAdapter ca) {
        this.copletAdapter = ca;
    }

    public Object getCopletConfig(String key) {
        return this.copletConfig.get(key);
    }

    public void setCopletConfig(String key, Object value) {
        if (this.copletConfig.size() == 0) {
            this.copletConfig = new HashMap();
        }
        this.copletConfig.put(key, value);
    }

    public Object removeCopletConfig(String key) {
        Object oldValue = this.copletConfig.remove(key);
        if (this.copletConfig.size() == 0) {
            this.copletConfig = Collections.EMPTY_MAP;
        }
        return oldValue;
    }

    public Map getCopletConfig() {
        return this.copletConfig;
    }

    public void setCopletConfig(Map config) {
        this.copletConfig = config == null || config.size() == 0 ? Collections.EMPTY_MAP : new HashMap(config);
    }

    public String toString() {
        return "CopletType (" + this.hashCode() + "), id=" + this.getId() + ", coplet-adapter=" + this.getCopletAdapter();
    }
}

