/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.om;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cocoon.portal.om.CopletType;
import org.apache.cocoon.portal.util.PortalUtils;
import org.apache.commons.lang.StringUtils;

public final class CopletDefinition {
    protected final String id;
    protected String title;
    protected CopletType copletType;
    protected Map attributes = Collections.EMPTY_MAP;
    protected String allowedRoles;
    protected transient List allowedRolesList;
    protected transient Map temporaryAttributes = Collections.EMPTY_MAP;

    public CopletDefinition(String id, CopletType type) {
        String idErrorMsg = PortalUtils.testId(id);
        if (idErrorMsg != null) {
            throw new IllegalArgumentException(idErrorMsg);
        }
        this.id = id;
        this.copletType = type;
    }

    public CopletDefinition(String id) {
        this(id, null);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CopletType getCopletType() {
        return this.copletType;
    }

    public void setCopletType(CopletType ct) {
        this.copletType = ct;
    }

    public Object removeAttribute(String key) {
        Object result = this.attributes.remove(key);
        if (this.attributes.size() == 0) {
            this.attributes = Collections.EMPTY_MAP;
        }
        return result;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes.size() == 0) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(String roles) {
        this.allowedRoles = roles;
        this.allowedRolesList = null;
    }

    public List getAllowedRolesList() {
        if (StringUtils.isBlank((String)this.allowedRoles)) {
            return null;
        }
        if (this.allowedRolesList == null) {
            this.allowedRolesList = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(this.allowedRoles, ",");
            while (tokenizer.hasMoreElements()) {
                String token = (String)tokenizer.nextElement();
                this.allowedRolesList.add(token);
            }
            if (this.allowedRolesList.size() == 0) {
                this.allowedRoles = null;
                this.allowedRolesList = null;
            }
        }
        return this.allowedRolesList;
    }

    public void addToAllowedRoles(String role) {
        ArrayList<String> l = this.getAllowedRolesList();
        if (l == null) {
            l = new ArrayList<String>();
            l.add(role);
        } else if (!l.contains(role)) {
            l.add(role);
        }
        this.buildRolesString(l);
    }

    public void removeFromAllowedRoles(String role) {
        List l = this.getAllowedRolesList();
        if (l != null && l.contains(role)) {
            l.remove(role);
            if (l.size() == 0) {
                this.allowedRoles = null;
                this.allowedRolesList = null;
            } else {
                this.buildRolesString(l);
            }
        }
    }

    protected void buildRolesString(List fromList) {
        this.allowedRolesList = fromList;
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (String role : fromList) {
            if (!first) {
                buffer.append(',');
            }
            first = false;
            buffer.append(role);
        }
        this.allowedRoles = buffer.toString();
    }

    public Object getTemporaryAttribute(String key) {
        return this.temporaryAttributes.get(key);
    }

    public void setTemporaryAttribute(String key, Object value) {
        if (this.temporaryAttributes.size() == 0) {
            this.temporaryAttributes = new HashMap();
        }
        this.temporaryAttributes.put(key, value);
    }

    public Object removeTemporaryAttribute(String key) {
        return this.temporaryAttributes.remove(key);
    }

    public String toString() {
        return "CopletDefinition (" + this.hashCode() + "), id=" + this.getId() + ", coplet-type=" + (this.getCopletType() == null ? "null" : this.getCopletType().getId());
    }
}

