/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.VoidChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.net.AsyncChannelPromise;
import org.apache.cassandra.transport.ClientResourceLimits;
import org.apache.cassandra.transport.Compressor;
import org.apache.cassandra.transport.Connection;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.Envelope;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.PipelineConfigurator;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.ServerConnection;
import org.apache.cassandra.transport.ServerError;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.StartupMessage;
import org.apache.cassandra.transport.messages.SupportedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialConnectionHandler
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(InitialConnectionHandler.class);
    final Envelope.Decoder decoder;
    final Connection.Factory factory;
    final PipelineConfigurator configurator;

    InitialConnectionHandler(Envelope.Decoder decoder, Connection.Factory factory, PipelineConfigurator configurator) {
        this.decoder = decoder;
        this.factory = factory;
        this.configurator = configurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> list) throws Exception {
        Envelope inbound = this.decoder.decode(buffer);
        if (inbound == null) {
            return;
        }
        try {
            switch (inbound.header.type) {
                case OPTIONS: {
                    logger.debug("OPTIONS received {}", (Object)inbound.header.version);
                    ArrayList<String> cqlVersions = new ArrayList<String>();
                    cqlVersions.add(QueryProcessor.CQL_VERSION.toString());
                    ArrayList<String> compressions = new ArrayList<String>();
                    if (Compressor.SnappyCompressor.instance != null) {
                        compressions.add("snappy");
                    }
                    compressions.add("lz4");
                    HashMap<String, List<String>> supportedOptions = new HashMap<String, List<String>>();
                    supportedOptions.put("CQL_VERSION", cqlVersions);
                    supportedOptions.put("COMPRESSION", compressions);
                    supportedOptions.put("PROTOCOL_VERSIONS", ProtocolVersion.supportedVersions());
                    SupportedMessage supported = new SupportedMessage(supportedOptions);
                    Envelope outbound = supported.encode(inbound.header.version);
                    ctx.writeAndFlush((Object)outbound);
                    return;
                }
                case STARTUP: {
                    void var15_19;
                    Attribute attrConn = ctx.channel().attr(Connection.attributeKey);
                    Connection connection = (Connection)attrConn.get();
                    if (connection == null) {
                        connection = this.factory.newConnection(ctx.channel(), inbound.header.version);
                        attrConn.set((Object)connection);
                    }
                    assert (connection instanceof ServerConnection);
                    StartupMessage startup = (StartupMessage)Message.Decoder.decodeMessage(ctx.channel(), inbound);
                    InetAddress remoteAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress();
                    ClientResourceLimits.Allocator allocator = ClientResourceLimits.getAllocatorForEndpoint(remoteAddress);
                    if (inbound.header.version.isGreaterOrEqualTo(ProtocolVersion.V5)) {
                        allocator.allocate(inbound.header.bodySizeInBytes);
                        AsyncChannelPromise asyncChannelPromise = AsyncChannelPromise.withListener(ctx, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> {
                            if (future.isSuccess()) {
                                logger.debug("Response to STARTUP sent, configuring pipeline for {}", (Object)inbound.header.version);
                                this.configurator.configureModernPipeline(ctx, allocator, inbound.header.version, startup.options);
                                allocator.release(inbound.header.bodySizeInBytes);
                            } else {
                                Throwable cause = future.cause();
                                if (null == cause) {
                                    cause = new ServerError("Unexpected error establishing connection");
                                }
                                logger.warn("Writing response to STARTUP failed, unable to configure pipeline", cause);
                                ErrorMessage error = ErrorMessage.fromException(cause);
                                Envelope response = error.encode(inbound.header.version);
                                AsyncChannelPromise closeChannel = AsyncChannelPromise.withListener(ctx, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)f -> ctx.close()));
                                ctx.writeAndFlush((Object)response, (ChannelPromise)closeChannel);
                                if (ctx.channel().isOpen()) {
                                    ctx.channel().close();
                                }
                            }
                        }));
                    } else {
                        this.configurator.configureLegacyPipeline(ctx, allocator);
                        VoidChannelPromise voidChannelPromise = new VoidChannelPromise(ctx.channel(), false);
                    }
                    Message.Response response = Dispatcher.processRequest((ServerConnection)connection, startup);
                    Envelope outbound = response.encode(inbound.header.version);
                    ctx.writeAndFlush((Object)outbound, (ChannelPromise)var15_19);
                    logger.debug("Configured pipeline: {}", (Object)ctx.pipeline());
                    return;
                }
                default: {
                    ErrorMessage error = ErrorMessage.fromException(new ProtocolException(String.format("Unexpected message %s, expecting STARTUP or OPTIONS", new Object[]{inbound.header.type})));
                    Envelope outbound = error.encode(inbound.header.version);
                    ctx.writeAndFlush((Object)outbound);
                    return;
                }
            }
        }
        finally {
            inbound.release();
        }
    }
}

