/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads;

import java.util.function.Function;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.tracing.Tracing;

class ShortReadRowsProtection
extends Transformation
implements MoreRows<UnfilteredRowIterator> {
    private final ReadCommand command;
    private final Replica source;
    private final DataLimits.Counter singleResultCounter;
    private final DataLimits.Counter mergedResultCounter;
    private final Function<ReadCommand, UnfilteredPartitionIterator> commandExecutor;
    private final TableMetadata metadata;
    private final DecoratedKey partitionKey;
    private Clustering<?> lastClustering;
    private int lastCounted = 0;
    private int lastFetched = 0;
    private int lastQueried = 0;

    ShortReadRowsProtection(DecoratedKey partitionKey, ReadCommand command, Replica source, Function<ReadCommand, UnfilteredPartitionIterator> commandExecutor, DataLimits.Counter singleResultCounter, DataLimits.Counter mergedResultCounter) {
        this.command = command;
        this.source = source;
        this.commandExecutor = commandExecutor;
        this.singleResultCounter = singleResultCounter;
        this.mergedResultCounter = mergedResultCounter;
        this.metadata = command.metadata();
        this.partitionKey = partitionKey;
    }

    @Override
    public Row applyToRow(Row row) {
        this.lastClustering = row.clustering();
        return row;
    }

    @Override
    public UnfilteredRowIterator moreContents() {
        assert (!this.mergedResultCounter.isDoneForPartition());
        assert (!this.command.limits().isUnlimited());
        if (!this.singleResultCounter.isDoneForPartition() && this.command.limits().perPartitionCount() == Integer.MAX_VALUE) {
            return null;
        }
        if (this.singleResultCounter.rowsCountedInCurrentPartition() == 0) {
            return null;
        }
        if (this.lastClustering != null && this.lastClustering.isEmpty()) {
            return null;
        }
        this.lastFetched = this.singleResultCounter.rowsCountedInCurrentPartition() - this.lastCounted;
        this.lastCounted = this.singleResultCounter.rowsCountedInCurrentPartition();
        if (this.lastQueried > 0 && this.lastFetched < this.lastQueried) {
            return null;
        }
        this.lastQueried = Math.min(this.command.limits().count(), this.command.limits().perPartitionCount());
        ColumnFamilyStore.metricsFor((TableId)this.metadata.id).shortReadProtectionRequests.mark();
        Tracing.trace("Requesting {} extra rows from {} for short read protection", (Object)this.lastQueried, (Object)this.source);
        SinglePartitionReadCommand cmd = this.makeFetchAdditionalRowsReadCommand(this.lastQueried);
        return UnfilteredPartitionIterators.getOnlyElement(this.commandExecutor.apply(cmd), cmd);
    }

    private SinglePartitionReadCommand makeFetchAdditionalRowsReadCommand(int toQuery) {
        ClusteringIndexFilter filter = this.command.clusteringIndexFilter(this.partitionKey);
        if (null != this.lastClustering) {
            filter = filter.forPaging(this.metadata.comparator, this.lastClustering, false);
        }
        return SinglePartitionReadCommand.create(this.command.metadata(), this.command.nowInSec(), this.command.columnFilter(), this.command.rowFilter(), this.command.limits().forShortReadRetry(toQuery), this.partitionKey, filter, this.command.indexMetadata());
    }
}

