/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InOurDcTester;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.locator.ReplicaLayout;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.locator.SystemReplicas;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.reads.AlwaysSpeculativeRetryPolicy;
import org.apache.cassandra.service.reads.SpeculativeRetryPolicy;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaPlans {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaPlans.class);
    public static final Selector writeAll = new Selector(){

        @Override
        public <E extends Endpoints<E>, L extends ReplicaLayout.ForWrite<E>> E select(Keyspace keyspace, ConsistencyLevel consistencyLevel, L liveAndDown, L live) {
            return liveAndDown.all();
        }
    };
    public static final Selector writeNormal = new Selector(){

        @Override
        public <E extends Endpoints<E>, L extends ReplicaLayout.ForWrite<E>> E select(Keyspace keyspace, ConsistencyLevel consistencyLevel, L liveAndDown, L live) {
            if (!Iterables.any(liveAndDown.all(), Replica::isTransient)) {
                return liveAndDown.all();
            }
            ReplicaCollection.Builder contacts = ((AbstractReplicaCollection)liveAndDown.all()).newBuilder(((AbstractReplicaCollection)liveAndDown.all()).size());
            contacts.addAll(Iterables.filter(liveAndDown.natural(), Replica::isFull));
            contacts.addAll((Iterable<Replica>)liveAndDown.pending());
            ObjectIntHashMap<String> requiredPerDc = ConsistencyLevel.eachQuorumForWrite(keyspace, liveAndDown.pending());
            Replicas.addToCountPerDc(requiredPerDc, ((AbstractReplicaCollection)live.natural()).filter(Replica::isFull), -1);
            Replicas.addToCountPerDc(requiredPerDc, live.pending(), -1);
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            for (Replica replica : Iterables.filter(live.natural(), Replica::isTransient)) {
                String dc = snitch.getDatacenter(replica);
                if (requiredPerDc.addTo((Object)dc, -1) < 0) continue;
                contacts.add(replica);
            }
            return (E)((Endpoints)contacts.build());
        }
    };

    public static boolean isSufficientLiveReplicasForRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, Endpoints<?> liveReplicas) {
        switch (consistencyLevel) {
            case ANY: {
                return true;
            }
            case LOCAL_ONE: {
                return Replicas.countInOurDc(liveReplicas).hasAtleast(1, 1);
            }
            case LOCAL_QUORUM: {
                return Replicas.countInOurDc(liveReplicas).hasAtleast(ConsistencyLevel.localQuorumForOurDc(keyspace), 1);
            }
            case EACH_QUORUM: {
                if (!(keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy)) break;
                int fullCount = 0;
                Set<String> dcs = ((NetworkTopologyStrategy)keyspace.getReplicationStrategy()).getDatacenters();
                for (ObjectObjectCursor entry : Replicas.countPerDc(dcs, liveReplicas)) {
                    Replicas.ReplicaCount count = (Replicas.ReplicaCount)entry.value;
                    if (!count.hasAtleast(ConsistencyLevel.localQuorumFor(keyspace, (String)entry.key), 0)) {
                        return false;
                    }
                    fullCount += count.fullReplicas();
                }
                return fullCount > 0;
            }
        }
        return liveReplicas.size() >= consistencyLevel.blockFor(keyspace) && Replicas.countFull(liveReplicas) > 0;
    }

    static void assureSufficientLiveReplicasForRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, Endpoints<?> liveReplicas) throws UnavailableException {
        ReplicaPlans.assureSufficientLiveReplicas(keyspace, consistencyLevel, liveReplicas, consistencyLevel.blockFor(keyspace), 1);
    }

    static void assureSufficientLiveReplicasForWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, Endpoints<?> allLive, Endpoints<?> pendingWithDown) throws UnavailableException {
        ReplicaPlans.assureSufficientLiveReplicas(keyspace, consistencyLevel, allLive, consistencyLevel.blockForWrite(keyspace, pendingWithDown), 0);
    }

    static void assureSufficientLiveReplicas(Keyspace keyspace, ConsistencyLevel consistencyLevel, Endpoints<?> allLive, int blockFor, int blockForFullReplicas) throws UnavailableException {
        switch (consistencyLevel) {
            case ANY: {
                break;
            }
            case LOCAL_ONE: {
                Replicas.ReplicaCount localLive = Replicas.countInOurDc(allLive);
                if (localLive.hasAtleast(blockFor, blockForFullReplicas)) break;
                throw UnavailableException.create(consistencyLevel, 1, blockForFullReplicas, localLive.allReplicas(), localLive.fullReplicas());
            }
            case LOCAL_QUORUM: {
                Replicas.ReplicaCount localLive = Replicas.countInOurDc(allLive);
                if (localLive.hasAtleast(blockFor, blockForFullReplicas)) break;
                if (logger.isTraceEnabled()) {
                    logger.trace(String.format("Local replicas %s are insufficient to satisfy LOCAL_QUORUM requirement of %d live replicas and %d full replicas in '%s'", allLive.filter((Predicate)InOurDcTester.replicas()), blockFor, blockForFullReplicas, DatabaseDescriptor.getLocalDataCenter()));
                }
                throw UnavailableException.create(consistencyLevel, blockFor, blockForFullReplicas, localLive.allReplicas(), localLive.fullReplicas());
            }
            case EACH_QUORUM: {
                if (keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy) {
                    int total = 0;
                    int totalFull = 0;
                    Set<String> dcs = ((NetworkTopologyStrategy)keyspace.getReplicationStrategy()).getDatacenters();
                    for (ObjectObjectCursor entry : Replicas.countPerDc(dcs, allLive)) {
                        Replicas.ReplicaCount dcCount = (Replicas.ReplicaCount)entry.value;
                        int dcBlockFor = ConsistencyLevel.localQuorumFor(keyspace, (String)entry.key);
                        if (!dcCount.hasAtleast(dcBlockFor, 0)) {
                            throw UnavailableException.create(consistencyLevel, (String)entry.key, dcBlockFor, dcCount.allReplicas(), 0, dcCount.fullReplicas());
                        }
                        totalFull += dcCount.fullReplicas();
                        total += dcCount.allReplicas();
                    }
                    if (totalFull >= blockForFullReplicas) break;
                    throw UnavailableException.create(consistencyLevel, blockFor, total, blockForFullReplicas, totalFull);
                }
            }
            default: {
                int live = allLive.size();
                int full = Replicas.countFull(allLive);
                if (live >= blockFor && full >= blockForFullReplicas) break;
                if (logger.isTraceEnabled()) {
                    logger.trace("Live nodes {} do not satisfy ConsistencyLevel ({} required)", (Object)Iterables.toString(allLive), (Object)blockFor);
                }
                throw UnavailableException.create(consistencyLevel, blockFor, blockForFullReplicas, live, full);
            }
        }
    }

    public static ReplicaPlan.ForTokenWrite forSingleReplicaWrite(Keyspace keyspace, Token token, Replica replica) {
        EndpointsForToken one = EndpointsForToken.of(token, replica);
        EndpointsForToken empty = EndpointsForToken.empty(token);
        return new ReplicaPlan.ForTokenWrite(keyspace, ConsistencyLevel.ONE, empty, one, one, one);
    }

    public static ReplicaPlan.ForTokenWrite forForwardingCounterWrite(Keyspace keyspace, Token token, Replica replica) {
        return ReplicaPlans.forSingleReplicaWrite(keyspace, token, replica);
    }

    public static ReplicaPlan.ForTokenWrite forLocalBatchlogWrite() {
        Token token = DatabaseDescriptor.getPartitioner().getMinimumToken();
        Keyspace systemKeypsace = Keyspace.open("system");
        Replica localSystemReplica = SystemReplicas.getSystemReplica(FBUtilities.getBroadcastAddressAndPort());
        ReplicaLayout.ForTokenWrite liveAndDown = ReplicaLayout.forTokenWrite(EndpointsForToken.of(token, localSystemReplica), EndpointsForToken.empty(token));
        return ReplicaPlans.forWrite(systemKeypsace, ConsistencyLevel.ONE, liveAndDown, liveAndDown, writeAll);
    }

    public static ReplicaPlan.ForTokenWrite forBatchlogWrite(boolean isAny) throws UnavailableException {
        ReplicaLayout.ForTokenWrite liveAndDown;
        Token token = DatabaseDescriptor.getPartitioner().getMinimumToken();
        TokenMetadata.Topology topology = StorageService.instance.getTokenMetadata().cachedOnlyTokenMap().getTopology();
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        HashMultimap localEndpoints = HashMultimap.create((Multimap)((Multimap)topology.getDatacenterRacks().get((Object)snitch.getLocalDatacenter())));
        Collection<InetAddressAndPort> chosenEndpoints = ReplicaPlans.filterBatchlogEndpoints(snitch.getLocalRack(), (Multimap<String, InetAddressAndPort>)localEndpoints);
        if (chosenEndpoints.isEmpty() && isAny) {
            chosenEndpoints = Collections.singleton(FBUtilities.getBroadcastAddressAndPort());
        }
        ConsistencyLevel consistencyLevel = ((EndpointsForToken)(liveAndDown = ReplicaLayout.forTokenWrite(SystemReplicas.getSystemReplicas(chosenEndpoints).forToken(token), EndpointsForToken.empty(token))).all()).size() == 1 ? ConsistencyLevel.ONE : ConsistencyLevel.TWO;
        Keyspace systemKeypsace = Keyspace.open("system");
        return ReplicaPlans.forWrite(systemKeypsace, consistencyLevel, liveAndDown, liveAndDown, writeAll);
    }

    private static Collection<InetAddressAndPort> filterBatchlogEndpoints(String localRack, Multimap<String, InetAddressAndPort> endpoints) {
        return ReplicaPlans.filterBatchlogEndpoints(localRack, endpoints, Collections::shuffle, FailureDetector.isEndpointAlive, ThreadLocalRandom.current()::nextInt);
    }

    @VisibleForTesting
    public static Collection<InetAddressAndPort> filterBatchlogEndpoints(String localRack, Multimap<String, InetAddressAndPort> endpoints, Consumer<List<?>> shuffle, Predicate<InetAddressAndPort> isAlive, Function<Integer, Integer> indexPicker) {
        Collection racks;
        if (endpoints.values().size() == 1) {
            return endpoints.values();
        }
        ArrayListMultimap validated = ArrayListMultimap.create();
        for (Map.Entry entry : endpoints.entries()) {
            InetAddressAndPort addr = (InetAddressAndPort)entry.getValue();
            if (addr.equals(FBUtilities.getBroadcastAddressAndPort()) || !isAlive.test(addr)) continue;
            validated.put(entry.getKey(), entry.getValue());
        }
        if (validated.size() <= 2) {
            return validated.values();
        }
        if (validated.size() - validated.get((Object)localRack).size() >= 2) {
            validated.removeAll((Object)localRack);
        }
        if (validated.keySet().size() == 1) {
            ArrayList otherRack = Lists.newArrayList((Iterable)validated.values());
            shuffle.accept(otherRack);
            return otherRack.subList(0, 2);
        }
        if (validated.keySet().size() == 2) {
            racks = validated.keySet();
        } else {
            racks = Lists.newArrayList((Iterable)validated.keySet());
            shuffle.accept((List)racks);
        }
        ArrayList<InetAddressAndPort> result = new ArrayList<InetAddressAndPort>(2);
        for (String rack : Iterables.limit((Iterable)racks, (int)2)) {
            List rackMembers = validated.get((Object)rack);
            result.add((InetAddressAndPort)rackMembers.get(indexPicker.apply(rackMembers.size())));
        }
        return result;
    }

    public static ReplicaPlan.ForTokenWrite forReadRepair(Token token, ReplicaPlan.ForRead<?> readPlan) throws UnavailableException {
        return ReplicaPlans.forWrite(readPlan.keyspace, readPlan.consistencyLevel, token, ReplicaPlans.writeReadRepair(readPlan));
    }

    public static ReplicaPlan.ForTokenWrite forWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, Token token, Selector selector) throws UnavailableException {
        return ReplicaPlans.forWrite(keyspace, consistencyLevel, ReplicaLayout.forTokenWriteLiveAndDown(keyspace, token), selector);
    }

    @VisibleForTesting
    public static ReplicaPlan.ForTokenWrite forWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, EndpointsForToken natural, EndpointsForToken pending, Predicate<Replica> isAlive, Selector selector) throws UnavailableException {
        return ReplicaPlans.forWrite(keyspace, consistencyLevel, ReplicaLayout.forTokenWrite(natural, pending), isAlive, selector);
    }

    public static ReplicaPlan.ForTokenWrite forWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, ReplicaLayout.ForTokenWrite liveAndDown, Selector selector) throws UnavailableException {
        return ReplicaPlans.forWrite(keyspace, consistencyLevel, liveAndDown, FailureDetector.isReplicaAlive, selector);
    }

    @VisibleForTesting
    public static ReplicaPlan.ForTokenWrite forWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, ReplicaLayout.ForTokenWrite liveAndDown, Predicate<Replica> isAlive, Selector selector) throws UnavailableException {
        ReplicaLayout.ForTokenWrite live = liveAndDown.filter(isAlive);
        return ReplicaPlans.forWrite(keyspace, consistencyLevel, liveAndDown, live, selector);
    }

    public static ReplicaPlan.ForTokenWrite forWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, ReplicaLayout.ForTokenWrite liveAndDown, ReplicaLayout.ForTokenWrite live, Selector selector) throws UnavailableException {
        EndpointsForToken contacts = (EndpointsForToken)selector.select(keyspace, consistencyLevel, liveAndDown, live);
        ReplicaPlans.assureSufficientLiveReplicasForWrite(keyspace, consistencyLevel, live.all(), liveAndDown.pending());
        return new ReplicaPlan.ForTokenWrite(keyspace, consistencyLevel, (EndpointsForToken)liveAndDown.pending(), (EndpointsForToken)liveAndDown.all(), (EndpointsForToken)live.all(), contacts);
    }

    public static Selector writeReadRepair(final ReplicaPlan.ForRead<?> readPlan) {
        return new Selector(){

            @Override
            public <E extends Endpoints<E>, L extends ReplicaLayout.ForWrite<E>> E select(Keyspace keyspace, ConsistencyLevel consistencyLevel, L liveAndDown, L live) {
                ReplicaCollection.Builder contacts;
                block3: {
                    block4: {
                        assert (!Iterables.any(liveAndDown.all(), Replica::isTransient));
                        contacts = ((AbstractReplicaCollection)live.all()).newBuilder(((AbstractReplicaCollection)live.all()).size());
                        contacts.addAll(Iterables.filter(live.all(), r -> ((Endpoints)readPlan.contacts()).endpoints().contains(r.endpoint())));
                        if (consistencyLevel == ConsistencyLevel.EACH_QUORUM) break block4;
                        int add = consistencyLevel.blockForWrite(keyspace, (Endpoints<?>)liveAndDown.pending()) - contacts.size();
                        if (add <= 0) break block3;
                        for (Replica replica : Iterables.filter(live.all(), r -> !contacts.contains((Replica)r))) {
                            contacts.add(replica);
                            if (--add != 0) continue;
                            break block3;
                        }
                        break block3;
                    }
                    ObjectIntHashMap<String> requiredPerDc = ConsistencyLevel.eachQuorumForWrite(keyspace, liveAndDown.pending());
                    Replicas.addToCountPerDc(requiredPerDc, contacts.snapshot(), -1);
                    IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
                    for (Replica replica : Iterables.filter(live.all(), r -> !contacts.contains((Replica)r))) {
                        String dc = snitch.getDatacenter(replica);
                        if (requiredPerDc.addTo((Object)dc, -1) < 0) continue;
                        contacts.add(replica);
                    }
                }
                return (E)((Endpoints)contacts.build());
            }
        };
    }

    public static ReplicaPlan.ForPaxosWrite forPaxos(Keyspace keyspace, DecoratedKey key, ConsistencyLevel consistencyForPaxos) throws UnavailableException {
        Token tk = key.getToken();
        ReplicaLayout.ForTokenWrite liveAndDown = ReplicaLayout.forTokenWriteLiveAndDown(keyspace, tk);
        Replicas.temporaryAssertFull(liveAndDown.all());
        if (consistencyForPaxos == ConsistencyLevel.LOCAL_SERIAL) {
            liveAndDown = liveAndDown.filter(InOurDcTester.replicas());
        }
        ReplicaLayout.ForTokenWrite live = liveAndDown.filter(FailureDetector.isReplicaAlive);
        int participants = ((EndpointsForToken)liveAndDown.all()).size();
        int requiredParticipants = participants / 2 + 1;
        EndpointsForToken contacts = (EndpointsForToken)live.all();
        if (contacts.size() < requiredParticipants) {
            throw UnavailableException.create(consistencyForPaxos, requiredParticipants, contacts.size());
        }
        if (((EndpointsForToken)liveAndDown.pending()).size() > 1) {
            throw new UnavailableException(String.format("Cannot perform LWT operation as there is more than one (%d) pending range movement", ((EndpointsForToken)liveAndDown.all()).size()), consistencyForPaxos, participants + 1, contacts.size());
        }
        return new ReplicaPlan.ForPaxosWrite(keyspace, consistencyForPaxos, (EndpointsForToken)liveAndDown.pending(), (EndpointsForToken)liveAndDown.all(), (EndpointsForToken)live.all(), contacts, requiredParticipants);
    }

    private static <E extends Endpoints<E>> E candidatesForRead(ConsistencyLevel consistencyLevel, E liveNaturalReplicas) {
        return (E)(consistencyLevel.isDatacenterLocal() ? (Endpoints)liveNaturalReplicas.filter((Predicate)InOurDcTester.replicas()) : liveNaturalReplicas);
    }

    private static <E extends Endpoints<E>> E contactForEachQuorumRead(Keyspace keyspace, E candidates) {
        assert (keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy);
        ObjectIntHashMap<String> perDc = ConsistencyLevel.eachQuorumForRead(keyspace);
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        return (E)((Endpoints)candidates.filter(replica -> {
            String dc = snitch.getDatacenter((Replica)replica);
            return perDc.addTo((Object)dc, -1) >= 0;
        }));
    }

    private static <E extends Endpoints<E>> E contactForRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, boolean alwaysSpeculate, E candidates) {
        if (consistencyLevel == ConsistencyLevel.EACH_QUORUM && keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy) {
            return ReplicaPlans.contactForEachQuorumRead(keyspace, candidates);
        }
        int count = consistencyLevel.blockFor(keyspace) + (alwaysSpeculate ? 1 : 0);
        return (E)((Endpoints)candidates.subList(0, Math.min(count, candidates.size())));
    }

    public static ReplicaPlan.ForTokenRead forSingleReplicaRead(Keyspace keyspace, Token token, Replica replica) {
        EndpointsForToken one = EndpointsForToken.of(token, replica);
        return new ReplicaPlan.ForTokenRead(keyspace, ConsistencyLevel.ONE, one, one);
    }

    public static ReplicaPlan.ForRangeRead forSingleReplicaRead(Keyspace keyspace, AbstractBounds<PartitionPosition> range, Replica replica, int vnodeCount) {
        EndpointsForRange one = EndpointsForRange.of(replica);
        return new ReplicaPlan.ForRangeRead(keyspace, ConsistencyLevel.ONE, range, one, one, vnodeCount);
    }

    public static ReplicaPlan.ForTokenRead forRead(Keyspace keyspace, Token token, ConsistencyLevel consistencyLevel, SpeculativeRetryPolicy retry) {
        EndpointsForToken candidates = (EndpointsForToken)ReplicaPlans.candidatesForRead(consistencyLevel, ReplicaLayout.forTokenReadLiveSorted(keyspace, token).natural());
        EndpointsForToken contacts = ReplicaPlans.contactForRead(keyspace, consistencyLevel, retry.equals(AlwaysSpeculativeRetryPolicy.INSTANCE), candidates);
        ReplicaPlans.assureSufficientLiveReplicasForRead(keyspace, consistencyLevel, contacts);
        return new ReplicaPlan.ForTokenRead(keyspace, consistencyLevel, candidates, contacts);
    }

    public static ReplicaPlan.ForRangeRead forRangeRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, AbstractBounds<PartitionPosition> range, int vnodeCount) {
        EndpointsForRange candidates = (EndpointsForRange)ReplicaPlans.candidatesForRead(consistencyLevel, ReplicaLayout.forRangeReadLiveSorted(keyspace, range).natural());
        EndpointsForRange contacts = ReplicaPlans.contactForRead(keyspace, consistencyLevel, false, candidates);
        ReplicaPlans.assureSufficientLiveReplicasForRead(keyspace, consistencyLevel, contacts);
        return new ReplicaPlan.ForRangeRead(keyspace, consistencyLevel, range, candidates, contacts, vnodeCount);
    }

    public static ReplicaPlan.ForRangeRead maybeMerge(Keyspace keyspace, ConsistencyLevel consistencyLevel, ReplicaPlan.ForRangeRead left, ReplicaPlan.ForRangeRead right) {
        AbstractBounds<PartitionPosition> newRange = left.range().withNewRight((PartitionPosition)right.range().right);
        EndpointsForRange mergedCandidates = (EndpointsForRange)((EndpointsForRange)left.candidates()).keep(((EndpointsForRange)right.candidates()).endpoints());
        if (!ReplicaPlans.isSufficientLiveReplicasForRead(keyspace, consistencyLevel, mergedCandidates)) {
            return null;
        }
        EndpointsForRange contacts = ReplicaPlans.contactForRead(keyspace, consistencyLevel, false, mergedCandidates);
        if (!DatabaseDescriptor.getEndpointSnitch().isWorthMergingForRangeQuery(contacts, (ReplicaCollection<?>)left.contacts(), (ReplicaCollection<?>)right.contacts())) {
            return null;
        }
        return new ReplicaPlan.ForRangeRead(keyspace, consistencyLevel, newRange, mergedCandidates, contacts, left.vnodeCount() + right.vnodeCount());
    }

    public static interface Selector {
        public <E extends Endpoints<E>, L extends ReplicaLayout.ForWrite<E>> E select(Keyspace var1, ConsistencyLevel var2, L var3, L var4);
    }
}

