/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public abstract class ReplicaLayout<E extends Endpoints<E>> {
    private final E natural;

    ReplicaLayout(E natural) {
        this.natural = natural;
    }

    public final E natural() {
        return this.natural;
    }

    public E all() {
        return this.natural;
    }

    public String toString() {
        return "ReplicaLayout [ natural: " + this.natural + " ]";
    }

    public static ForTokenWrite forTokenWriteLiveAndDown(Keyspace keyspace, Token token) {
        EndpointsForToken natural = keyspace.getReplicationStrategy().getNaturalReplicasForToken(token);
        EndpointsForToken pending = StorageService.instance.getTokenMetadata().pendingEndpointsForToken(token, keyspace.getName());
        return ReplicaLayout.forTokenWrite(natural, pending);
    }

    public static ForTokenWrite forTokenWrite(EndpointsForToken natural, EndpointsForToken pending) {
        if (ReplicaLayout.haveWriteConflicts(natural, pending)) {
            natural = ReplicaLayout.resolveWriteConflictsInNatural(natural, pending);
            pending = ReplicaLayout.resolveWriteConflictsInPending(natural, pending);
        }
        return new ForTokenWrite(natural, pending);
    }

    static <E extends Endpoints<E>> boolean haveWriteConflicts(E natural, E pending) {
        Set<InetAddressAndPort> naturalEndpoints = natural.endpoints();
        for (InetAddressAndPort pendingEndpoint : pending.endpoints()) {
            if (!naturalEndpoints.contains(pendingEndpoint)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static EndpointsForToken resolveWriteConflictsInNatural(EndpointsForToken natural, EndpointsForToken pending) {
        EndpointsForToken.Builder resolved = natural.newBuilder(natural.size());
        for (Replica replica : natural) {
            Replica conflict;
            if (replica.isTransient() && (conflict = pending.byEndpoint().get(replica.endpoint())) != null) {
                assert (conflict.isFull());
                resolved.add(conflict);
                continue;
            }
            resolved.add(replica);
        }
        return resolved.build();
    }

    @VisibleForTesting
    static EndpointsForToken resolveWriteConflictsInPending(EndpointsForToken natural, EndpointsForToken pending) {
        return (EndpointsForToken)pending.without(natural.endpoints());
    }

    static ForTokenRead forTokenReadLiveSorted(Keyspace keyspace, Token token) {
        EndpointsForToken replicas = keyspace.getReplicationStrategy().getNaturalReplicasForToken(token);
        replicas = DatabaseDescriptor.getEndpointSnitch().sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), replicas);
        replicas = (EndpointsForToken)replicas.filter((Predicate)FailureDetector.isReplicaAlive);
        return new ForTokenRead(replicas);
    }

    static ForRangeRead forRangeReadLiveSorted(Keyspace keyspace, AbstractBounds<PartitionPosition> range) {
        EndpointsForRange replicas = keyspace.getReplicationStrategy().getNaturalReplicas((RingPosition)range.right);
        replicas = DatabaseDescriptor.getEndpointSnitch().sortedByProximity(FBUtilities.getBroadcastAddressAndPort(), replicas);
        replicas = (EndpointsForRange)replicas.filter((Predicate)FailureDetector.isReplicaAlive);
        return new ForRangeRead(range, replicas);
    }

    public static interface ForToken {
        public Token token();
    }

    public static interface ForRange {
        public AbstractBounds<PartitionPosition> range();
    }

    public static class ForTokenWrite
    extends ForWrite<EndpointsForToken>
    implements ForToken {
        public ForTokenWrite(EndpointsForToken natural, EndpointsForToken pending) {
            this(natural, pending, null);
        }

        public ForTokenWrite(EndpointsForToken natural, EndpointsForToken pending, EndpointsForToken all) {
            super(natural, pending, all);
        }

        @Override
        public Token token() {
            return ((EndpointsForToken)this.natural()).token();
        }

        public ForTokenWrite filter(Predicate<Replica> filter) {
            EndpointsForToken filtered = (EndpointsForToken)((EndpointsForToken)this.all()).filter((Predicate)filter);
            if (filtered == this.all()) {
                return this;
            }
            return new ForTokenWrite((EndpointsForToken)((EndpointsForToken)this.natural()).keep(filtered.endpoints()), (EndpointsForToken)((EndpointsForToken)this.pending()).keep(filtered.endpoints()), filtered);
        }
    }

    public static class ForWrite<E extends Endpoints<E>>
    extends ReplicaLayout<E> {
        final E all;
        final E pending;

        ForWrite(E natural, E pending, E all) {
            super(natural);
            assert (pending != null && !ForWrite.haveWriteConflicts(natural, pending));
            if (all == null) {
                all = Endpoints.concat(natural, pending);
            }
            this.all = all;
            this.pending = pending;
        }

        @Override
        public final E all() {
            return this.all;
        }

        public final E pending() {
            return this.pending;
        }

        @Override
        public String toString() {
            return "ReplicaLayout [ natural: " + this.natural() + ", pending: " + this.pending + " ]";
        }
    }

    public static class ForRangeRead
    extends ReplicaLayout<EndpointsForRange>
    implements ForRange {
        final AbstractBounds<PartitionPosition> range;

        public ForRangeRead(AbstractBounds<PartitionPosition> range, EndpointsForRange natural) {
            super(natural);
            this.range = range;
        }

        @Override
        public AbstractBounds<PartitionPosition> range() {
            return this.range;
        }

        public ForRangeRead filter(Predicate<Replica> filter) {
            EndpointsForRange filtered = (EndpointsForRange)((EndpointsForRange)this.natural()).filter((Predicate)filter);
            if (filtered == this.natural()) {
                return this;
            }
            return new ForRangeRead(this.range(), filtered);
        }
    }

    public static class ForTokenRead
    extends ReplicaLayout<EndpointsForToken>
    implements ForToken {
        public ForTokenRead(EndpointsForToken natural) {
            super(natural);
        }

        @Override
        public Token token() {
            return ((EndpointsForToken)this.natural()).token();
        }

        public ForTokenRead filter(Predicate<Replica> filter) {
            EndpointsForToken filtered = (EndpointsForToken)((EndpointsForToken)this.natural()).filter((Predicate)filter);
            if (filtered == this.natural()) {
                return this;
            }
            return new ForTokenRead(filtered);
        }
    }
}

