/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import java.util.Collection;
import java.util.UUID;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderBuilder;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;

public class BigFormat
implements SSTableFormat {
    public static final BigFormat instance = new BigFormat();
    public static final Version latestVersion = new BigVersion("na");
    private static final SSTableReader.Factory readerFactory = new ReaderFactory();
    private static final SSTableWriter.Factory writerFactory = new WriterFactory();

    private BigFormat() {
    }

    @Override
    public Version getLatestVersion() {
        return latestVersion;
    }

    @Override
    public Version getVersion(String version) {
        return new BigVersion(version);
    }

    @Override
    public SSTableWriter.Factory getWriterFactory() {
        return writerFactory;
    }

    @Override
    public SSTableReader.Factory getReaderFactory() {
        return readerFactory;
    }

    public RowIndexEntry.IndexSerializer getIndexSerializer(TableMetadata metadata, Version version, SerializationHeader header) {
        return new RowIndexEntry.Serializer(version, header);
    }

    static class BigVersion
    extends Version {
        public static final String current_version = "na";
        public static final String earliest_supported_version = "ma";
        private final boolean isLatestVersion;
        public final int correspondingMessagingVersion;
        private final boolean hasCommitLogLowerBound;
        private final boolean hasCommitLogIntervals;
        private final boolean hasAccurateMinMax;
        public final boolean hasMaxCompressedLength;
        private final boolean hasPendingRepair;
        private final boolean hasMetadataChecksum;
        private final boolean hasIsTransient;
        private final boolean hasOldBfFormat;

        BigVersion(String version) {
            super(instance, version);
            this.isLatestVersion = version.compareTo(current_version) == 0;
            this.correspondingMessagingVersion = 10;
            this.hasCommitLogLowerBound = version.compareTo("mb") >= 0;
            this.hasCommitLogIntervals = version.compareTo("mc") >= 0;
            this.hasAccurateMinMax = version.compareTo("md") >= 0;
            this.hasMaxCompressedLength = version.compareTo(current_version) >= 0;
            this.hasPendingRepair = version.compareTo(current_version) >= 0;
            this.hasIsTransient = version.compareTo(current_version) >= 0;
            this.hasMetadataChecksum = version.compareTo(current_version) >= 0;
            this.hasOldBfFormat = version.compareTo(current_version) < 0;
        }

        @Override
        public boolean isLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public boolean hasCommitLogLowerBound() {
            return this.hasCommitLogLowerBound;
        }

        @Override
        public boolean hasCommitLogIntervals() {
            return this.hasCommitLogIntervals;
        }

        @Override
        public boolean hasPendingRepair() {
            return this.hasPendingRepair;
        }

        @Override
        public boolean hasIsTransient() {
            return this.hasIsTransient;
        }

        @Override
        public int correspondingMessagingVersion() {
            return this.correspondingMessagingVersion;
        }

        @Override
        public boolean hasMetadataChecksum() {
            return this.hasMetadataChecksum;
        }

        @Override
        public boolean hasAccurateMinMax() {
            return this.hasAccurateMinMax;
        }

        @Override
        public boolean isCompatible() {
            return this.version.compareTo(earliest_supported_version) >= 0 && this.version.charAt(0) <= current_version.charAt(0);
        }

        @Override
        public boolean isCompatibleForStreaming() {
            return this.isCompatible() && this.version.charAt(0) == current_version.charAt(0);
        }

        @Override
        public boolean hasMaxCompressedLength() {
            return this.hasMaxCompressedLength;
        }

        @Override
        public boolean hasOldBfFormat() {
            return this.hasOldBfFormat;
        }
    }

    static class ReaderFactory
    extends SSTableReader.Factory {
        ReaderFactory() {
        }

        @Override
        public SSTableReader open(SSTableReaderBuilder builder) {
            return new BigTableReader(builder);
        }
    }

    static class WriterFactory
    extends SSTableWriter.Factory {
        WriterFactory() {
        }

        @Override
        public SSTableWriter open(Descriptor descriptor, long keyCount, long repairedAt, UUID pendingRepair, boolean isTransient, TableMetadataRef metadata, MetadataCollector metadataCollector, SerializationHeader header, Collection<SSTableFlushObserver> observers, LifecycleNewTracker lifecycleNewTracker) {
            SSTable.validateRepairedMetadata(repairedAt, pendingRepair, isTransient);
            return new BigTableWriter(descriptor, keyCount, repairedAt, pendingRepair, isTransient, metadata, metadataCollector, header, observers, lifecycleNewTracker);
        }
    }
}

