/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringBoundary;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.ByteArrayAccessor;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.exceptions.UnknownColumnException;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.WrappedException;

public class UnfilteredSerializer {
    public static final UnfilteredSerializer serializer = new UnfilteredSerializer();
    private static final int END_OF_PARTITION = 1;
    private static final int IS_MARKER = 2;
    private static final int HAS_TIMESTAMP = 4;
    private static final int HAS_TTL = 8;
    private static final int HAS_DELETION = 16;
    private static final int HAS_ALL_COLUMNS = 32;
    private static final int HAS_COMPLEX_DELETION = 64;
    private static final int EXTENSION_FLAG = 128;
    private static final int IS_STATIC = 1;
    @Deprecated
    private static final int HAS_SHADOWABLE_DELETION = 2;

    public void serialize(Unfiltered unfiltered, SerializationHelper helper, DataOutputPlus out, int version) throws IOException {
        assert (!helper.header.isForSSTable());
        this.serialize(unfiltered, helper, out, 0L, version);
    }

    public void serialize(Unfiltered unfiltered, SerializationHelper helper, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        if (unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            this.serialize((RangeTombstoneMarker)unfiltered, helper, out, previousUnfilteredSize, version);
        } else {
            this.serialize((Row)unfiltered, helper, out, previousUnfilteredSize, version);
        }
    }

    public void serializeStaticRow(Row row, SerializationHelper helper, DataOutputPlus out, int version) throws IOException {
        assert (row.isStatic());
        this.serialize(row, helper, out, 0L, version);
    }

    private void serialize(Row row, SerializationHelper helper, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        int flags = 0;
        int extendedFlags = 0;
        boolean isStatic = row.isStatic();
        SerializationHeader header = helper.header;
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        Row.Deletion deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        boolean hasAllColumns = helper.hasAllColumns(row, isStatic);
        boolean hasExtendedFlags = UnfilteredSerializer.hasExtendedFlags(row);
        if (isStatic) {
            extendedFlags |= 1;
        }
        if (!pkLiveness.isEmpty()) {
            flags |= 4;
        }
        if (pkLiveness.isExpiring()) {
            flags |= 8;
        }
        if (!deletion.isLive()) {
            flags |= 0x10;
            if (deletion.isShadowable()) {
                extendedFlags |= 2;
            }
        }
        if (hasComplexDeletion) {
            flags |= 0x40;
        }
        if (hasAllColumns) {
            flags |= 0x20;
        }
        if (hasExtendedFlags) {
            flags |= 0x80;
        }
        out.writeByte((byte)flags);
        if (hasExtendedFlags) {
            out.writeByte((byte)extendedFlags);
        }
        if (!isStatic) {
            Clustering.serializer.serialize((Clustering<?>)row.clustering(), out, version, header.clusteringTypes());
        }
        if (header.isForSSTable()) {
            try (DataOutputBuffer dob = (DataOutputBuffer)DataOutputBuffer.scratchBuffer.get();){
                this.serializeRowBody(row, flags, helper, dob);
                out.writeUnsignedVInt(dob.position() + (long)TypeSizes.sizeofUnsignedVInt(previousUnfilteredSize));
                out.writeUnsignedVInt(previousUnfilteredSize);
                out.write(dob.getData(), 0, dob.getLength());
            }
        } else {
            this.serializeRowBody(row, flags, helper, out);
        }
    }

    private void serializeRowBody(Row row, int flags, SerializationHelper helper, DataOutputPlus out) throws IOException {
        boolean isStatic = row.isStatic();
        SerializationHeader header = helper.header;
        Columns headerColumns = header.columns(isStatic);
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        Row.Deletion deletion = row.deletion();
        if ((flags & 4) != 0) {
            header.writeTimestamp(pkLiveness.timestamp(), out);
        }
        if ((flags & 8) != 0) {
            header.writeTTL(pkLiveness.ttl(), out);
            header.writeLocalDeletionTime(pkLiveness.localExpirationTime(), out);
        }
        if ((flags & 0x10) != 0) {
            header.writeDeletionTime(deletion.time(), out);
        }
        if ((flags & 0x20) == 0) {
            Columns.serializer.serializeSubset(row.columns(), headerColumns, out);
        }
        SearchIterator<ColumnMetadata, ColumnMetadata> si = helper.iterator(isStatic);
        try {
            row.apply(cd -> {
                ColumnMetadata column = (ColumnMetadata)si.next(cd.column());
                if (column == null) {
                    return;
                }
                try {
                    if (cd.column.isSimple()) {
                        Cell.serializer.serialize((Cell)cd, column, out, pkLiveness, header);
                    } else {
                        this.writeComplexColumn((ComplexColumnData)cd, column, (flags & 0x40) != 0, pkLiveness, header, out);
                    }
                }
                catch (IOException e) {
                    throw new WrappedException(e);
                }
            });
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private void writeComplexColumn(ComplexColumnData data, ColumnMetadata column, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header, DataOutputPlus out) throws IOException {
        if (hasComplexDeletion) {
            header.writeDeletionTime(data.complexDeletion(), out);
        }
        out.writeUnsignedVInt(data.cellsCount());
        for (Cell<?> cell : data) {
            Cell.serializer.serialize(cell, column, out, rowLiveness, header);
        }
    }

    private void serialize(RangeTombstoneMarker marker, SerializationHelper helper, DataOutputPlus out, long previousUnfilteredSize, int version) throws IOException {
        SerializationHeader header = helper.header;
        out.writeByte(2);
        ClusteringBoundOrBoundary.serializer.serialize(marker.clustering(), out, version, header.clusteringTypes());
        if (header.isForSSTable()) {
            out.writeUnsignedVInt(this.serializedMarkerBodySize(marker, header, previousUnfilteredSize, version));
            out.writeUnsignedVInt(previousUnfilteredSize);
        }
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            header.writeDeletionTime(bm.endDeletionTime(), out);
            header.writeDeletionTime(bm.startDeletionTime(), out);
        } else {
            header.writeDeletionTime(((RangeTombstoneBoundMarker)marker).deletionTime(), out);
        }
    }

    public long serializedSize(Unfiltered unfiltered, SerializationHelper helper, int version) {
        assert (!helper.header.isForSSTable());
        return this.serializedSize(unfiltered, helper, 0L, version);
    }

    public long serializedSize(Unfiltered unfiltered, SerializationHelper helper, long previousUnfilteredSize, int version) {
        return unfiltered.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER ? this.serializedSize((RangeTombstoneMarker)unfiltered, helper, previousUnfilteredSize, version) : this.serializedSize((Row)unfiltered, helper, previousUnfilteredSize, version);
    }

    private long serializedSize(Row row, SerializationHelper helper, long previousUnfilteredSize, int version) {
        long size = 1L;
        if (UnfilteredSerializer.hasExtendedFlags(row)) {
            ++size;
        }
        if (!row.isStatic()) {
            size += Clustering.serializer.serializedSize((Clustering<?>)row.clustering(), version, helper.header.clusteringTypes());
        }
        return size + this.serializedRowBodySize(row, helper, previousUnfilteredSize, version);
    }

    private long serializedRowBodySize(Row row, SerializationHelper helper, long previousUnfilteredSize, int version) {
        long size = 0L;
        SerializationHeader header = helper.header;
        if (header.isForSSTable()) {
            size += (long)TypeSizes.sizeofUnsignedVInt(previousUnfilteredSize);
        }
        boolean isStatic = row.isStatic();
        LivenessInfo pkLiveness = row.primaryKeyLivenessInfo();
        Row.Deletion deletion = row.deletion();
        boolean hasComplexDeletion = row.hasComplexDeletion();
        boolean hasAllColumns = helper.hasAllColumns(row, isStatic);
        if (!pkLiveness.isEmpty()) {
            size += header.timestampSerializedSize(pkLiveness.timestamp());
        }
        if (pkLiveness.isExpiring()) {
            size += header.ttlSerializedSize(pkLiveness.ttl());
            size += header.localDeletionTimeSerializedSize(pkLiveness.localExpirationTime());
        }
        if (!deletion.isLive()) {
            size += header.deletionTimeSerializedSize(deletion.time());
        }
        if (!hasAllColumns) {
            size += Columns.serializer.serializedSubsetSize(row.columns(), header.columns(isStatic));
        }
        SearchIterator<ColumnMetadata, ColumnMetadata> si = helper.iterator(isStatic);
        return row.accumulate((data, v) -> {
            ColumnMetadata column = (ColumnMetadata)si.next(data.column());
            if (column == null) {
                return v;
            }
            if (data.column.isSimple()) {
                return v + Cell.serializer.serializedSize((Cell)data, column, pkLiveness, header);
            }
            return v + this.sizeOfComplexColumn((ComplexColumnData)data, column, hasComplexDeletion, pkLiveness, header);
        }, size);
    }

    private long sizeOfComplexColumn(ComplexColumnData data, ColumnMetadata column, boolean hasComplexDeletion, LivenessInfo rowLiveness, SerializationHeader header) {
        long size = 0L;
        if (hasComplexDeletion) {
            size += header.deletionTimeSerializedSize(data.complexDeletion());
        }
        size += (long)TypeSizes.sizeofUnsignedVInt(data.cellsCount());
        for (Cell<?> cell : data) {
            size += Cell.serializer.serializedSize(cell, column, rowLiveness, header);
        }
        return size;
    }

    private long serializedSize(RangeTombstoneMarker marker, SerializationHelper helper, long previousUnfilteredSize, int version) {
        assert (!helper.header.isForSSTable());
        return 1L + ClusteringBoundOrBoundary.serializer.serializedSize(marker.clustering(), version, helper.header.clusteringTypes()) + this.serializedMarkerBodySize(marker, helper.header, previousUnfilteredSize, version);
    }

    private long serializedMarkerBodySize(RangeTombstoneMarker marker, SerializationHeader header, long previousUnfilteredSize, int version) {
        long size = 0L;
        if (header.isForSSTable()) {
            size += (long)TypeSizes.sizeofUnsignedVInt(previousUnfilteredSize);
        }
        if (marker.isBoundary()) {
            RangeTombstoneBoundaryMarker bm = (RangeTombstoneBoundaryMarker)marker;
            size += header.deletionTimeSerializedSize(bm.endDeletionTime());
            size += header.deletionTimeSerializedSize(bm.startDeletionTime());
        } else {
            size += header.deletionTimeSerializedSize(((RangeTombstoneBoundMarker)marker).deletionTime());
        }
        return size;
    }

    public void writeEndOfPartition(DataOutputPlus out) throws IOException {
        out.writeByte(1);
    }

    public long serializedSizeEndOfPartition() {
        return 1L;
    }

    public Unfiltered deserialize(DataInputPlus in, SerializationHeader header, DeserializationHelper helper, Row.Builder builder) throws IOException {
        Unfiltered unfiltered;
        do {
            if ((unfiltered = this.deserializeOne(in, header, helper, builder)) != null) continue;
            return null;
        } while (unfiltered.isEmpty());
        return unfiltered;
    }

    private Unfiltered deserializeOne(DataInputPlus in, SerializationHeader header, DeserializationHelper helper, Row.Builder builder) throws IOException {
        assert (builder.isSorted());
        int flags = in.readUnsignedByte();
        if (UnfilteredSerializer.isEndOfPartition(flags)) {
            return null;
        }
        int extendedFlags = UnfilteredSerializer.readExtendedFlags(in, flags);
        if (UnfilteredSerializer.kind(flags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
            ClusteringBoundOrBoundary<byte[]> bound = ClusteringBoundOrBoundary.serializer.deserialize(in, helper.version, header.clusteringTypes());
            return this.deserializeMarkerBody(in, header, bound);
        }
        if (UnfilteredSerializer.isStatic(extendedFlags)) {
            throw new IOException("Corrupt flags value for unfiltered partition (isStatic flag set): " + flags);
        }
        builder.newRow(Clustering.serializer.deserialize(in, helper.version, header.clusteringTypes()));
        return this.deserializeRowBody(in, header, helper, flags, extendedFlags, builder);
    }

    public Unfiltered deserializeTombstonesOnly(FileDataInput in, SerializationHeader header, DeserializationHelper helper) throws IOException {
        int flags;
        while (!UnfilteredSerializer.isEndOfPartition(flags = in.readUnsignedByte())) {
            int extendedFlags = UnfilteredSerializer.readExtendedFlags(in, flags);
            if (UnfilteredSerializer.kind(flags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                ClusteringBoundOrBoundary<byte[]> bound = ClusteringBoundOrBoundary.serializer.deserialize(in, helper.version, header.clusteringTypes());
                return this.deserializeMarkerBody(in, header, bound);
            }
            assert (!UnfilteredSerializer.isStatic(extendedFlags));
            if ((flags & 0x10) != 0) {
                assert (header.isForSSTable());
                boolean hasTimestamp = (flags & 4) != 0;
                boolean hasTTL = (flags & 8) != 0;
                boolean deletionIsShadowable = (extendedFlags & 2) != 0;
                Clustering<byte[]> clustering = Clustering.serializer.deserialize(in, helper.version, header.clusteringTypes());
                long nextPosition = in.readUnsignedVInt() + in.getFilePointer();
                in.readUnsignedVInt();
                if (hasTimestamp) {
                    header.readTimestamp(in);
                    if (hasTTL) {
                        header.readTTL(in);
                        header.readLocalDeletionTime(in);
                    }
                }
                Row.Deletion deletion = new Row.Deletion(header.readDeletionTime(in), deletionIsShadowable);
                in.seek(nextPosition);
                return BTreeRow.emptyDeletedRow(clustering, deletion);
            }
            Clustering.serializer.skip(in, helper.version, header.clusteringTypes());
            this.skipRowBody(in);
        }
        return null;
    }

    public Row deserializeStaticRow(DataInputPlus in, SerializationHeader header, DeserializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isExtended(flags)) : flags;
        int extendedFlags = in.readUnsignedByte();
        Row.Builder builder = BTreeRow.sortedBuilder();
        builder.newRow(Clustering.STATIC_CLUSTERING);
        return this.deserializeRowBody(in, header, helper, flags, extendedFlags, builder);
    }

    public RangeTombstoneMarker deserializeMarkerBody(DataInputPlus in, SerializationHeader header, ClusteringBoundOrBoundary<?> bound) throws IOException {
        if (header.isForSSTable()) {
            in.readUnsignedVInt();
            in.readUnsignedVInt();
        }
        if (bound.isBoundary()) {
            return new RangeTombstoneBoundaryMarker((ClusteringBoundary)bound, header.readDeletionTime(in), header.readDeletionTime(in));
        }
        return new RangeTombstoneBoundMarker((ClusteringBound)bound, header.readDeletionTime(in));
    }

    public Row deserializeRowBody(DataInputPlus in, SerializationHeader header, DeserializationHelper helper, int flags, int extendedFlags, Row.Builder builder) throws IOException {
        try {
            boolean isStatic = UnfilteredSerializer.isStatic(extendedFlags);
            boolean hasTimestamp = (flags & 4) != 0;
            boolean hasTTL = (flags & 8) != 0;
            boolean hasDeletion = (flags & 0x10) != 0;
            boolean deletionIsShadowable = (extendedFlags & 2) != 0;
            boolean hasComplexDeletion = (flags & 0x40) != 0;
            boolean hasAllColumns = (flags & 0x20) != 0;
            Columns headerColumns = header.columns(isStatic);
            if (header.isForSSTable()) {
                in.readUnsignedVInt();
                in.readUnsignedVInt();
            }
            LivenessInfo rowLiveness = LivenessInfo.EMPTY;
            if (hasTimestamp) {
                long timestamp = header.readTimestamp(in);
                int ttl = hasTTL ? header.readTTL(in) : 0;
                int localDeletionTime = hasTTL ? header.readLocalDeletionTime(in) : Integer.MAX_VALUE;
                rowLiveness = LivenessInfo.withExpirationTime(timestamp, ttl, localDeletionTime);
            }
            builder.addPrimaryKeyLivenessInfo(rowLiveness);
            builder.addRowDeletion(hasDeletion ? new Row.Deletion(header.readDeletionTime(in), deletionIsShadowable) : Row.Deletion.LIVE);
            Columns columns = hasAllColumns ? headerColumns : Columns.serializer.deserializeSubset(headerColumns, in);
            LivenessInfo livenessInfo = rowLiveness;
            try {
                columns.apply(column -> {
                    try {
                        if (column.isPlaceholder()) {
                            throw new UnknownColumnException("Unknown column " + UTF8Type.instance.getString(column.name.bytes) + " during deserialization");
                        }
                        if (column.isSimple()) {
                            this.readSimpleColumn((ColumnMetadata)column, in, header, helper, builder, livenessInfo);
                        } else {
                            this.readComplexColumn((ColumnMetadata)column, in, header, helper, hasComplexDeletion, builder, livenessInfo);
                        }
                    }
                    catch (IOException e) {
                        throw new WrappedException(e);
                    }
                });
            }
            catch (WrappedException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            return builder.build();
        }
        catch (AssertionError | RuntimeException e) {
            throw new IOException("Error building row with data deserialized from " + in, (Throwable)e);
        }
    }

    private void readSimpleColumn(ColumnMetadata column, DataInputPlus in, SerializationHeader header, DeserializationHelper helper, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            Cell<byte[]> cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper, ByteArrayAccessor.instance);
            if (helper.includes(cell, rowLiveness) && !helper.isDropped(cell, false)) {
                builder.addCell(cell);
            }
        } else {
            Cell.serializer.skip(in, column, header);
        }
    }

    private void readComplexColumn(ColumnMetadata column, DataInputPlus in, SerializationHeader header, DeserializationHelper helper, boolean hasComplexDeletion, Row.Builder builder, LivenessInfo rowLiveness) throws IOException {
        if (helper.includes(column)) {
            DeletionTime complexDeletion;
            helper.startOfComplexColumn(column);
            if (hasComplexDeletion && !helper.isDroppedComplexDeletion(complexDeletion = header.readDeletionTime(in))) {
                builder.addComplexDeletion(column, complexDeletion);
            }
            int count = (int)in.readUnsignedVInt();
            while (--count >= 0) {
                Cell<byte[]> cell = Cell.serializer.deserialize(in, rowLiveness, column, header, helper, ByteArrayAccessor.instance);
                if (!helper.includes(cell, rowLiveness) || helper.isDropped(cell, true)) continue;
                builder.addCell(cell);
            }
            helper.endOfComplexColumn();
        } else {
            this.skipComplexColumn(in, column, header, hasComplexDeletion);
        }
    }

    public void skipRowBody(DataInputPlus in) throws IOException {
        int rowSize = (int)in.readUnsignedVInt();
        in.skipBytesFully(rowSize);
    }

    public void skipStaticRow(DataInputPlus in, SerializationHeader header, DeserializationHelper helper) throws IOException {
        int flags = in.readUnsignedByte();
        assert (!UnfilteredSerializer.isEndOfPartition(flags) && UnfilteredSerializer.kind(flags) == Unfiltered.Kind.ROW && UnfilteredSerializer.isExtended(flags)) : "Flags is " + flags;
        int extendedFlags = in.readUnsignedByte();
        assert (UnfilteredSerializer.isStatic(extendedFlags));
        this.skipRowBody(in);
    }

    public void skipMarkerBody(DataInputPlus in) throws IOException {
        int markerSize = (int)in.readUnsignedVInt();
        in.skipBytesFully(markerSize);
    }

    private void skipComplexColumn(DataInputPlus in, ColumnMetadata column, SerializationHeader header, boolean hasComplexDeletion) throws IOException {
        if (hasComplexDeletion) {
            header.skipDeletionTime(in);
        }
        int count = (int)in.readUnsignedVInt();
        while (--count >= 0) {
            Cell.serializer.skip(in, column, header);
        }
    }

    public static boolean isEndOfPartition(int flags) {
        return (flags & 1) != 0;
    }

    public static Unfiltered.Kind kind(int flags) {
        return (flags & 2) != 0 ? Unfiltered.Kind.RANGE_TOMBSTONE_MARKER : Unfiltered.Kind.ROW;
    }

    public static boolean isStatic(int extendedFlags) {
        return (extendedFlags & 1) != 0;
    }

    private static boolean isExtended(int flags) {
        return (flags & 0x80) != 0;
    }

    public static int readExtendedFlags(DataInputPlus in, int flags) throws IOException {
        return UnfilteredSerializer.isExtended(flags) ? in.readUnsignedByte() : 0;
    }

    public static boolean hasExtendedFlags(Row row) {
        return row.isStatic() || row.deletion().isShadowable();
    }
}

