/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.RawSelector;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.ViewMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class CreateViewStatement
extends AlterSchemaStatement {
    private final String tableName;
    private final String viewName;
    private final List<RawSelector> rawColumns;
    private final List<ColumnIdentifier> partitionKeyColumns;
    private final List<ColumnIdentifier> clusteringColumns;
    private final WhereClause whereClause;
    private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder;
    private final TableAttributes attrs;
    private final boolean ifNotExists;

    public CreateViewStatement(String keyspaceName, String tableName, String viewName, List<RawSelector> rawColumns, List<ColumnIdentifier> partitionKeyColumns, List<ColumnIdentifier> clusteringColumns, WhereClause whereClause, LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder, TableAttributes attrs, boolean ifNotExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.viewName = viewName;
        this.rawColumns = rawColumns;
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringColumns = clusteringColumns;
        this.whereClause = whereClause;
        this.clusteringOrder = clusteringOrder;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        if (!DatabaseDescriptor.getEnableMaterializedViews()) {
            throw CreateViewStatement.ire("Materialized views are disabled. Enable in cassandra.yaml to use.", new Object[0]);
        }
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateViewStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        if (keyspace.createReplicationStrategy().hasTransientReplicas()) {
            throw new InvalidRequestException("Materialized views are not supported on transiently replicated keyspaces");
        }
        TableMetadata table = keyspace.tables.getNullable(this.tableName);
        if (null == table) {
            throw CreateViewStatement.ire("Base table '%s' doesn't exist", this.tableName);
        }
        if (keyspace.hasTable(this.viewName)) {
            throw CreateViewStatement.ire("Cannot create materialized view '%s' - a table with the same name already exists", this.viewName);
        }
        if (keyspace.hasView(this.viewName)) {
            if (this.ifNotExists) {
                return schema;
            }
            throw new AlreadyExistsException(this.keyspaceName, this.viewName);
        }
        if (table.isCounter()) {
            throw CreateViewStatement.ire("Materialized views are not supported on counter tables", new Object[0]);
        }
        if (table.isView()) {
            throw CreateViewStatement.ire("Materialized views cannot be created against other materialized views", new Object[0]);
        }
        if (table.params.gcGraceSeconds == 0) {
            throw CreateViewStatement.ire("Cannot create materialized view '%s' for base table '%s' with gc_grace_seconds of 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.", this.viewName, this.tableName);
        }
        HashSet selectedColumns = new HashSet();
        if (this.rawColumns.isEmpty()) {
            table.columns().forEach(c -> selectedColumns.add(c.name));
        }
        this.rawColumns.forEach(selector -> {
            if (null != selector.alias) {
                throw CreateViewStatement.ire("Cannot use aliases when defining a materialized view (got %s)", selector);
            }
            if (!(selector.selectable instanceof Selectable.RawIdentifier)) {
                throw CreateViewStatement.ire("Can only select columns by name when defining a materialized view (got %s)", selector.selectable);
            }
            ColumnMetadata column = (ColumnMetadata)selector.selectable.prepare(table);
            selectedColumns.add(column.name);
        });
        selectedColumns.stream().map(table::getColumn).filter(ColumnMetadata::isStatic).findAny().ifPresent(c -> {
            throw CreateViewStatement.ire("Cannot include static column '%s' in materialized view '%s'", c, this.viewName);
        });
        if (this.partitionKeyColumns.isEmpty()) {
            throw CreateViewStatement.ire("Must provide at least one partition key column for materialized view '%s'", this.viewName);
        }
        HashSet primaryKeyColumns = new HashSet();
        Iterables.concat(this.partitionKeyColumns, this.clusteringColumns).forEach(name -> {
            ColumnMetadata column = table.getColumn((ColumnIdentifier)name);
            if (null == column || !selectedColumns.contains(name)) {
                throw CreateViewStatement.ire("Unknown column '%s' referenced in PRIMARY KEY for materialized view '%s'", name, this.viewName);
            }
            if (!primaryKeyColumns.add(name)) {
                throw CreateViewStatement.ire("Duplicate column '%s' in PRIMARY KEY clause for materialized view '%s'", name, this.viewName);
            }
            AbstractType type = column.type;
            if (type.isMultiCell()) {
                if (type.isCollection()) {
                    throw CreateViewStatement.ire("Invalid non-frozen collection type '%s' for PRIMARY KEY column '%s'", type, name);
                }
                throw CreateViewStatement.ire("Invalid non-frozen user-defined type '%s' for PRIMARY KEY column '%s'", type, name);
            }
            if (type.isCounter()) {
                throw CreateViewStatement.ire("counter type is not supported for PRIMARY KEY column '%s'", name);
            }
            if (type.referencesDuration()) {
                throw CreateViewStatement.ire("duration type is not supported for PRIMARY KEY column '%s'", name);
            }
        });
        if (!this.clusteringOrder.isEmpty() && !this.clusteringColumns.equals(new ArrayList<ColumnIdentifier>(this.clusteringOrder.keySet()))) {
            throw CreateViewStatement.ire("Clustering key columns must exactly match columns in CLUSTERING ORDER BY directive", new Object[0]);
        }
        ArrayList missingPrimaryKeyColumns = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(table.primaryKeyColumns(), c -> c.name), c -> !primaryKeyColumns.contains(c)));
        if (!missingPrimaryKeyColumns.isEmpty()) {
            throw CreateViewStatement.ire("Cannot create materialized view '%s' without primary key columns %s from base table '%s'", this.viewName, String.join((CharSequence)", ", Iterables.transform((Iterable)missingPrimaryKeyColumns, ColumnIdentifier::toString)), this.tableName);
        }
        HashSet regularBaseTableColumnsInViewPrimaryKey = new HashSet(primaryKeyColumns);
        Iterables.transform(table.primaryKeyColumns(), c -> c.name).forEach(regularBaseTableColumnsInViewPrimaryKey::remove);
        if (regularBaseTableColumnsInViewPrimaryKey.size() > 1) {
            throw CreateViewStatement.ire("Cannot include more than one non-primary key column in materialized view primary key (got %s)", String.join((CharSequence)", ", Iterables.transform(regularBaseTableColumnsInViewPrimaryKey, ColumnIdentifier::toString)));
        }
        if (this.whereClause.containsCustomExpressions()) {
            throw CreateViewStatement.ire("WHERE clause for materialized view '%s' cannot contain custom index expressions", this.viewName);
        }
        StatementRestrictions restrictions = new StatementRestrictions(StatementType.SELECT, table, this.whereClause, VariableSpecifications.empty(), false, false, true, true);
        ArrayList nonRestrictedPrimaryKeyColumns = Lists.newArrayList((Iterable)Iterables.filter(primaryKeyColumns, name -> !restrictions.isRestricted(table.getColumn((ColumnIdentifier)name))));
        if (!nonRestrictedPrimaryKeyColumns.isEmpty()) {
            throw CreateViewStatement.ire("Primary key columns %s must be restricted with 'IS NOT NULL' or otherwise", String.join((CharSequence)", ", Iterables.transform((Iterable)nonRestrictedPrimaryKeyColumns, ColumnIdentifier::toString)));
        }
        Set<ColumnMetadata> restrictedNonPrimaryKeyColumns = restrictions.nonPKRestrictedColumns(false);
        if (!restrictedNonPrimaryKeyColumns.isEmpty() && !Boolean.getBoolean("cassandra.mv.allow_filtering_nonkey_columns_unsafe")) {
            throw CreateViewStatement.ire("Non-primary key columns can only be restricted with 'IS NOT NULL' (got: %s restricted illegally)", String.join((CharSequence)",", Iterables.transform(restrictedNonPrimaryKeyColumns, ColumnMetadata::toString)));
        }
        this.attrs.validate();
        if (this.attrs.hasOption(TableParams.Option.DEFAULT_TIME_TO_LIVE)) {
            throw CreateViewStatement.ire("Cannot set default_time_to_live for a materialized view. Data in a materialized view always expire at the same time than the corresponding data in the parent table.", new Object[0]);
        }
        TableMetadata.Builder builder = TableMetadata.builder(this.keyspaceName, this.viewName);
        if (this.attrs.hasProperty("id").booleanValue()) {
            builder.id(this.attrs.getId());
        }
        builder.params(this.attrs.asNewTableParams()).kind(TableMetadata.Kind.VIEW);
        this.partitionKeyColumns.forEach(name -> builder.addPartitionKeyColumn((ColumnIdentifier)name, (AbstractType)this.getType(table, (ColumnIdentifier)name)));
        this.clusteringColumns.forEach(name -> builder.addClusteringColumn((ColumnIdentifier)name, (AbstractType)this.getType(table, (ColumnIdentifier)name)));
        selectedColumns.stream().filter(name -> !primaryKeyColumns.contains(name)).forEach(name -> builder.addRegularColumn((ColumnIdentifier)name, (AbstractType)this.getType(table, (ColumnIdentifier)name)));
        ViewMetadata view = new ViewMetadata(table.id, table.name, this.rawColumns.isEmpty(), this.whereClause, builder.build());
        view.metadata.validate();
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.views.with(view)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.viewName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureTablePermission(this.keyspaceName, this.tableName, Permission.ALTER);
    }

    private AbstractType<?> getType(TableMetadata table, ColumnIdentifier name) {
        boolean reverse;
        AbstractType type = table.getColumn((ColumnIdentifier)name).type;
        boolean bl = reverse = this.clusteringOrder.getOrDefault(name, true) == false;
        if (type.isReversed() && !reverse) {
            return ((ReversedType)type).baseType;
        }
        if (!type.isReversed() && reverse) {
            return ReversedType.getInstance(type);
        }
        return type;
    }

    @Override
    Set<String> clientWarnings(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of((Object)"Materialized views are experimental and are not recommended for production use.");
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_VIEW, this.keyspaceName, this.viewName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.viewName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName tableName;
        private final QualifiedName viewName;
        private final boolean ifNotExists;
        private final List<RawSelector> rawColumns;
        private final List<ColumnIdentifier> clusteringColumns = new ArrayList<ColumnIdentifier>();
        private List<ColumnIdentifier> partitionKeyColumns;
        private final WhereClause whereClause;
        private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder = new LinkedHashMap();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName tableName, QualifiedName viewName, List<RawSelector> rawColumns, WhereClause whereClause, boolean ifNotExists) {
            this.tableName = tableName;
            this.viewName = viewName;
            this.rawColumns = rawColumns;
            this.whereClause = whereClause;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateViewStatement prepare(ClientState state) {
            String keyspaceName;
            String string = keyspaceName = this.viewName.hasKeyspace() ? this.viewName.getKeyspace() : state.getKeyspace();
            if (this.tableName.hasKeyspace() && !keyspaceName.equals(this.tableName.getKeyspace())) {
                throw AlterSchemaStatement.ire("Cannot create a materialized view on a table in a different keyspace", new Object[0]);
            }
            if (!this.bindVariables.isEmpty()) {
                throw AlterSchemaStatement.ire("Bind variables are not allowed in CREATE MATERIALIZED VIEW statements", new Object[0]);
            }
            if (null == this.partitionKeyColumns) {
                throw AlterSchemaStatement.ire("No PRIMARY KEY specifed for view '%s' (exactly one required)", this.viewName);
            }
            return new CreateViewStatement(keyspaceName, this.tableName.getName(), this.viewName.getName(), this.rawColumns, this.partitionKeyColumns, this.clusteringColumns, this.whereClause, this.clusteringOrder, this.attrs, this.ifNotExists);
        }

        public void setPartitionKeyColumns(List<ColumnIdentifier> columns) {
            this.partitionKeyColumns = columns;
        }

        public void markClusteringColumn(ColumnIdentifier column) {
            this.clusteringColumns.add(column);
        }

        public void extendClusteringOrder(ColumnIdentifier column, boolean ascending) {
            if (null != this.clusteringOrder.put(column, ascending)) {
                throw AlterSchemaStatement.ire("Duplicate column '%s' in CLUSTERING ORDER BY clause for view '%s'", column, this.viewName);
            }
        }
    }
}

