/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.batchlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDSerializer;

public final class Batch {
    public static final Serializer serializer = new Serializer();
    public final UUID id;
    public final long creationTime;
    final Collection<Mutation> decodedMutations;
    final Collection<ByteBuffer> encodedMutations;

    private Batch(UUID id, long creationTime, Collection<Mutation> decodedMutations, Collection<ByteBuffer> encodedMutations) {
        this.id = id;
        this.creationTime = creationTime;
        this.decodedMutations = decodedMutations;
        this.encodedMutations = encodedMutations;
    }

    public static Batch createLocal(UUID id, long creationTime, Collection<Mutation> mutations) {
        return new Batch(id, creationTime, mutations, Collections.emptyList());
    }

    public static Batch createRemote(UUID id, long creationTime, Collection<ByteBuffer> mutations) {
        return new Batch(id, creationTime, Collections.emptyList(), mutations);
    }

    public int size() {
        return this.decodedMutations.size() + this.encodedMutations.size();
    }

    static final class Serializer
    implements IVersionedSerializer<Batch> {
        Serializer() {
        }

        @Override
        public long serializedSize(Batch batch, int version) {
            assert (batch.encodedMutations.isEmpty()) : "attempted to serialize a 'remote' batch";
            long size = UUIDSerializer.serializer.serializedSize(batch.id, version);
            size += (long)TypeSizes.sizeof(batch.creationTime);
            size += (long)TypeSizes.sizeofUnsignedVInt(batch.decodedMutations.size());
            for (Mutation mutation : batch.decodedMutations) {
                int mutationSize = mutation.serializedSize(version);
                size += (long)TypeSizes.sizeofUnsignedVInt(mutationSize);
                size += (long)mutationSize;
            }
            return size;
        }

        @Override
        public void serialize(Batch batch, DataOutputPlus out, int version) throws IOException {
            assert (batch.encodedMutations.isEmpty()) : "attempted to serialize a 'remote' batch";
            UUIDSerializer.serializer.serialize(batch.id, out, version);
            out.writeLong(batch.creationTime);
            out.writeUnsignedVInt(batch.decodedMutations.size());
            for (Mutation mutation : batch.decodedMutations) {
                out.writeUnsignedVInt(mutation.serializedSize(version));
                Mutation.serializer.serialize(mutation, out, version);
            }
        }

        @Override
        public Batch deserialize(DataInputPlus in, int version) throws IOException {
            UUID id = UUIDSerializer.serializer.deserialize(in, version);
            long creationTime = in.readLong();
            return version == 12 ? Batch.createRemote(id, creationTime, Serializer.readEncodedMutations(in)) : Batch.createLocal(id, creationTime, Serializer.decodeMutations(in, version));
        }

        private static Collection<ByteBuffer> readEncodedMutations(DataInputPlus in) throws IOException {
            int count = (int)in.readUnsignedVInt();
            ArrayList<ByteBuffer> mutations = new ArrayList<ByteBuffer>(count);
            for (int i = 0; i < count; ++i) {
                mutations.add(ByteBufferUtil.readWithVIntLength(in));
            }
            return mutations;
        }

        private static Collection<Mutation> decodeMutations(DataInputPlus in, int version) throws IOException {
            int count = (int)in.readUnsignedVInt();
            ArrayList<Mutation> mutations = new ArrayList<Mutation>(count);
            for (int i = 0; i < count; ++i) {
                in.readUnsignedVInt();
                mutations.add(Mutation.serializer.deserialize(in, version));
            }
            return mutations;
        }
    }
}

