/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.utils.MBeanWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthCache<K, V>
implements AuthCacheMBean {
    private static final Logger logger = LoggerFactory.getLogger(AuthCache.class);
    private static final String MBEAN_NAME_BASE = "org.apache.cassandra.auth:type=";
    protected volatile LoadingCache<K, V> cache;
    private String name;
    private IntConsumer setValidityDelegate;
    private IntSupplier getValidityDelegate;
    private IntConsumer setUpdateIntervalDelegate;
    private IntSupplier getUpdateIntervalDelegate;
    private IntConsumer setMaxEntriesDelegate;
    private IntSupplier getMaxEntriesDelegate;
    private Function<K, V> loadFunction;
    private BooleanSupplier enableCache;

    protected AuthCache(String name, IntConsumer setValidityDelegate, IntSupplier getValidityDelegate, IntConsumer setUpdateIntervalDelegate, IntSupplier getUpdateIntervalDelegate, IntConsumer setMaxEntriesDelegate, IntSupplier getMaxEntriesDelegate, Function<K, V> loadFunction, BooleanSupplier cacheEnabledDelegate) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.setValidityDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setValidityDelegate);
        this.getValidityDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getValidityDelegate);
        this.setUpdateIntervalDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setUpdateIntervalDelegate);
        this.getUpdateIntervalDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getUpdateIntervalDelegate);
        this.setMaxEntriesDelegate = (IntConsumer)Preconditions.checkNotNull((Object)setMaxEntriesDelegate);
        this.getMaxEntriesDelegate = (IntSupplier)Preconditions.checkNotNull((Object)getMaxEntriesDelegate);
        this.loadFunction = (Function)Preconditions.checkNotNull(loadFunction);
        this.enableCache = (BooleanSupplier)Preconditions.checkNotNull((Object)cacheEnabledDelegate);
        this.init();
    }

    protected void init() {
        this.cache = this.initCache(null);
        MBeanWrapper.instance.registerMBean((Object)this, this.getObjectName());
    }

    protected void unregisterMBean() {
        MBeanWrapper.instance.unregisterMBean(this.getObjectName(), MBeanWrapper.OnException.LOG);
    }

    protected String getObjectName() {
        return MBEAN_NAME_BASE + this.name;
    }

    public V get(K k) {
        if (this.cache == null) {
            return this.loadFunction.apply(k);
        }
        return (V)this.cache.get(k);
    }

    @Override
    public void invalidate() {
        this.cache = this.initCache(null);
    }

    public void invalidate(K k) {
        if (this.cache != null) {
            this.cache.invalidate(k);
        }
    }

    @Override
    public void setValidity(int validityPeriod) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setValidityDelegate.accept(validityPeriod);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getValidity() {
        return this.getValidityDelegate.getAsInt();
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setUpdateIntervalDelegate.accept(updateInterval);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getUpdateInterval() {
        return this.getUpdateIntervalDelegate.getAsInt();
    }

    @Override
    public void setMaxEntries(int maxEntries) {
        if (Boolean.getBoolean("cassandra.disable_auth_caches_remote_configuration")) {
            throw new UnsupportedOperationException("Remote configuration of auth caches is disabled");
        }
        this.setMaxEntriesDelegate.accept(maxEntries);
        this.cache = this.initCache(this.cache);
    }

    @Override
    public int getMaxEntries() {
        return this.getMaxEntriesDelegate.getAsInt();
    }

    protected LoadingCache<K, V> initCache(LoadingCache<K, V> existing) {
        if (!this.enableCache.getAsBoolean()) {
            return null;
        }
        if (this.getValidity() <= 0) {
            return null;
        }
        logger.info("(Re)initializing {} (validity period/update interval/max entries) ({}/{}/{})", new Object[]{this.name, this.getValidity(), this.getUpdateInterval(), this.getMaxEntries()});
        if (existing == null) {
            return Caffeine.newBuilder().refreshAfterWrite((long)this.getUpdateInterval(), TimeUnit.MILLISECONDS).expireAfterWrite((long)this.getValidity(), TimeUnit.MILLISECONDS).maximumSize((long)this.getMaxEntries()).executor(MoreExecutors.directExecutor()).build(this.loadFunction::apply);
        }
        this.cache.policy().refreshAfterWrite().ifPresent(policy -> policy.setExpiresAfter((long)this.getUpdateInterval(), TimeUnit.MILLISECONDS));
        this.cache.policy().expireAfterWrite().ifPresent(policy -> policy.setExpiresAfter((long)this.getValidity(), TimeUnit.MILLISECONDS));
        this.cache.policy().eviction().ifPresent(policy -> policy.setMaximum((long)this.getMaxEntries()));
        return this.cache;
    }
}

