/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.ResponseResolver;

public class DigestResolver
extends ResponseResolver {
    private volatile ReadResponse dataResponse;

    public DigestResolver(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, int maxResponseCount) {
        super(keyspace, command, consistency, maxResponseCount);
    }

    @Override
    public void preprocess(MessageIn<ReadResponse> message) {
        super.preprocess(message);
        if (this.dataResponse == null && !((ReadResponse)message.payload).isDigestResponse()) {
            this.dataResponse = (ReadResponse)message.payload;
        }
    }

    @Override
    public PartitionIterator getData() {
        assert (this.isDataPresent());
        return UnfilteredPartitionIterators.filter(this.dataResponse.makeIterator(this.command.metadata(), this.command), this.command.nowInSec());
    }

    @Override
    public PartitionIterator resolve() throws DigestMismatchException {
        if (this.responses.size() == 1) {
            return this.getData();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolving {} responses", (Object)this.responses.size());
        }
        long start = System.nanoTime();
        ByteBuffer digest = null;
        for (MessageIn message : this.responses) {
            ReadResponse response = (ReadResponse)message.payload;
            ByteBuffer newDigest = response.digest(this.command.metadata(), this.command);
            if (digest == null) {
                digest = newDigest;
                continue;
            }
            if (digest.equals(newDigest)) continue;
            throw new DigestMismatchException(((SinglePartitionReadCommand)this.command).partitionKey(), digest, newDigest);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        return UnfilteredPartitionIterators.filter(this.dataResponse.makeIterator(this.command.metadata(), this.command), this.command.nowInSec());
    }

    @Override
    public boolean isDataPresent() {
        return this.dataResponse != null;
    }
}

